// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains details about a saved CloudWatch Logs Insights query definition.
 */
public class QueryDefinition private constructor(builder: Builder) {
    /**
     * The date that the query definition was most recently modified.
     */
    public val lastModified: kotlin.Long? = builder.lastModified
    /**
     * If this query definition contains a list of log groups that it is limited to, that list appears here.
     */
    public val logGroupNames: List<String>? = builder.logGroupNames
    /**
     * The name of the query definition.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The unique ID of the query definition.
     */
    public val queryDefinitionId: kotlin.String? = builder.queryDefinitionId
    /**
     * The query language used for this query. For more information about the query languages that CloudWatch Logs supports, see [Supported query languages](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html).
     */
    public val queryLanguage: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryLanguage? = builder.queryLanguage
    /**
     * The query string to use for this definition. For more information, see [CloudWatch Logs Insights Query Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
     */
    public val queryString: kotlin.String? = builder.queryString

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryDefinition(")
        append("lastModified=$lastModified,")
        append("logGroupNames=$logGroupNames,")
        append("name=$name,")
        append("queryDefinitionId=$queryDefinitionId,")
        append("queryLanguage=$queryLanguage,")
        append("queryString=$queryString")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastModified?.hashCode() ?: 0
        result = 31 * result + (logGroupNames?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queryDefinitionId?.hashCode() ?: 0)
        result = 31 * result + (queryLanguage?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryDefinition

        if (lastModified != other.lastModified) return false
        if (logGroupNames != other.logGroupNames) return false
        if (name != other.name) return false
        if (queryDefinitionId != other.queryDefinitionId) return false
        if (queryLanguage != other.queryLanguage) return false
        if (queryString != other.queryString) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date that the query definition was most recently modified.
         */
        public var lastModified: kotlin.Long? = null
        /**
         * If this query definition contains a list of log groups that it is limited to, that list appears here.
         */
        public var logGroupNames: List<String>? = null
        /**
         * The name of the query definition.
         */
        public var name: kotlin.String? = null
        /**
         * The unique ID of the query definition.
         */
        public var queryDefinitionId: kotlin.String? = null
        /**
         * The query language used for this query. For more information about the query languages that CloudWatch Logs supports, see [Supported query languages](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html).
         */
        public var queryLanguage: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryLanguage? = null
        /**
         * The query string to use for this definition. For more information, see [CloudWatch Logs Insights Query Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
         */
        public var queryString: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryDefinition) : this() {
            this.lastModified = x.lastModified
            this.logGroupNames = x.logGroupNames
            this.name = x.name
            this.queryDefinitionId = x.queryDefinitionId
            this.queryLanguage = x.queryLanguage
            this.queryString = x.queryString
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryDefinition = QueryDefinition(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
