// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutSubscriptionFilterRequest private constructor(builder: Builder) {
    /**
     * This parameter is valid only for log groups that have an active log transformer. For more information about log transformers, see [PutTransformer](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html).
     *
     * If the log group uses either a log-group level or account-level transformer, and you specify `true`, the subscription filter will be applied on the transformed version of the log events instead of the original ingested log events.
     */
    public val applyOnTransformedLogs: kotlin.Boolean? = builder.applyOnTransformedLogs
    /**
     * The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:
     * + An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.
     * + A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.If you're setting up a cross-account subscription, the destination must have an IAM policy associated with it. The IAM policy must allow the sender to send logs to the destination. For more information, see [PutDestinationPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html).
     * + A Kinesis Data Firehose delivery stream belonging to the same account as the subscription filter, for same-account delivery.
     * + A Lambda function belonging to the same account as the subscription filter, for same-account delivery.
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis data stream.
     */
    public val distribution: aws.sdk.kotlin.services.cloudwatchlogs.model.Distribution? = builder.distribution
    /**
     * A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in `filterName`. To find the name of the filter currently associated with a log group, use [DescribeSubscriptionFilters](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html).
     */
    public val filterName: kotlin.String? = builder.filterName
    /**
     * A filter pattern for subscribing to a filtered stream of log events.
     */
    public val filterPattern: kotlin.String? = builder.filterPattern
    /**
     * The name of the log group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.PutSubscriptionFilterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutSubscriptionFilterRequest(")
        append("applyOnTransformedLogs=$applyOnTransformedLogs,")
        append("destinationArn=$destinationArn,")
        append("distribution=$distribution,")
        append("filterName=$filterName,")
        append("filterPattern=$filterPattern,")
        append("logGroupName=$logGroupName,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyOnTransformedLogs?.hashCode() ?: 0
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (distribution?.hashCode() ?: 0)
        result = 31 * result + (filterName?.hashCode() ?: 0)
        result = 31 * result + (filterPattern?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutSubscriptionFilterRequest

        if (applyOnTransformedLogs != other.applyOnTransformedLogs) return false
        if (destinationArn != other.destinationArn) return false
        if (distribution != other.distribution) return false
        if (filterName != other.filterName) return false
        if (filterPattern != other.filterPattern) return false
        if (logGroupName != other.logGroupName) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.PutSubscriptionFilterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter is valid only for log groups that have an active log transformer. For more information about log transformers, see [PutTransformer](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html).
         *
         * If the log group uses either a log-group level or account-level transformer, and you specify `true`, the subscription filter will be applied on the transformed version of the log events instead of the original ingested log events.
         */
        public var applyOnTransformedLogs: kotlin.Boolean? = null
        /**
         * The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:
         * + An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.
         * + A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.If you're setting up a cross-account subscription, the destination must have an IAM policy associated with it. The IAM policy must allow the sender to send logs to the destination. For more information, see [PutDestinationPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html).
         * + A Kinesis Data Firehose delivery stream belonging to the same account as the subscription filter, for same-account delivery.
         * + A Lambda function belonging to the same account as the subscription filter, for same-account delivery.
         */
        public var destinationArn: kotlin.String? = null
        /**
         * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis data stream.
         */
        public var distribution: aws.sdk.kotlin.services.cloudwatchlogs.model.Distribution? = null
        /**
         * A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in `filterName`. To find the name of the filter currently associated with a log group, use [DescribeSubscriptionFilters](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html).
         */
        public var filterName: kotlin.String? = null
        /**
         * A filter pattern for subscribing to a filtered stream of log events.
         */
        public var filterPattern: kotlin.String? = null
        /**
         * The name of the log group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.PutSubscriptionFilterRequest) : this() {
            this.applyOnTransformedLogs = x.applyOnTransformedLogs
            this.destinationArn = x.destinationArn
            this.distribution = x.distribution
            this.filterName = x.filterName
            this.filterPattern = x.filterPattern
            this.logGroupName = x.logGroupName
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.PutSubscriptionFilterRequest = PutSubscriptionFilterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
