// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutQueryDefinitionRequest private constructor(builder: Builder) {
    /**
     * Used as an idempotency token, to avoid returning an exception if the service receives the same request twice because of a network error.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Use this parameter to include specific log groups as part of your query definition. If your query uses the OpenSearch Service query language, you specify the log group names inside the `querystring` instead of here.
     *
     * If you are updating an existing query definition for the Logs Insights QL or OpenSearch Service PPL and you omit this parameter, then the updated definition will contain no log groups.
     */
    public val logGroupNames: List<String>? = builder.logGroupNames
    /**
     * A name for the query definition. If you are saving numerous query definitions, we recommend that you name them. This way, you can find the ones you want by using the first part of the name as a filter in the `queryDefinitionNamePrefix` parameter of [DescribeQueryDefinitions](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html).
     */
    public val name: kotlin.String? = builder.name
    /**
     * If you are updating a query definition, use this parameter to specify the ID of the query definition that you want to update. You can use [DescribeQueryDefinitions](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html) to retrieve the IDs of your saved query definitions.
     *
     * If you are creating a query definition, do not specify this parameter. CloudWatch generates a unique ID for the new query definition and include it in the response to this operation.
     */
    public val queryDefinitionId: kotlin.String? = builder.queryDefinitionId
    /**
     * Specify the query language to use for this query. The options are Logs Insights QL, OpenSearch PPL, and OpenSearch SQL. For more information about the query languages that CloudWatch Logs supports, see [Supported query languages](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html).
     */
    public val queryLanguage: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryLanguage? = builder.queryLanguage
    /**
     * The query string to use for this definition. For more information, see [CloudWatch Logs Insights Query Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
     */
    public val queryString: kotlin.String? = builder.queryString

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.PutQueryDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutQueryDefinitionRequest(")
        append("clientToken=$clientToken,")
        append("logGroupNames=$logGroupNames,")
        append("name=$name,")
        append("queryDefinitionId=$queryDefinitionId,")
        append("queryLanguage=$queryLanguage,")
        append("queryString=$queryString")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (logGroupNames?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queryDefinitionId?.hashCode() ?: 0)
        result = 31 * result + (queryLanguage?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutQueryDefinitionRequest

        if (clientToken != other.clientToken) return false
        if (logGroupNames != other.logGroupNames) return false
        if (name != other.name) return false
        if (queryDefinitionId != other.queryDefinitionId) return false
        if (queryLanguage != other.queryLanguage) return false
        if (queryString != other.queryString) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.PutQueryDefinitionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Used as an idempotency token, to avoid returning an exception if the service receives the same request twice because of a network error.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Use this parameter to include specific log groups as part of your query definition. If your query uses the OpenSearch Service query language, you specify the log group names inside the `querystring` instead of here.
         *
         * If you are updating an existing query definition for the Logs Insights QL or OpenSearch Service PPL and you omit this parameter, then the updated definition will contain no log groups.
         */
        public var logGroupNames: List<String>? = null
        /**
         * A name for the query definition. If you are saving numerous query definitions, we recommend that you name them. This way, you can find the ones you want by using the first part of the name as a filter in the `queryDefinitionNamePrefix` parameter of [DescribeQueryDefinitions](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html).
         */
        public var name: kotlin.String? = null
        /**
         * If you are updating a query definition, use this parameter to specify the ID of the query definition that you want to update. You can use [DescribeQueryDefinitions](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html) to retrieve the IDs of your saved query definitions.
         *
         * If you are creating a query definition, do not specify this parameter. CloudWatch generates a unique ID for the new query definition and include it in the response to this operation.
         */
        public var queryDefinitionId: kotlin.String? = null
        /**
         * Specify the query language to use for this query. The options are Logs Insights QL, OpenSearch PPL, and OpenSearch SQL. For more information about the query languages that CloudWatch Logs supports, see [Supported query languages](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html).
         */
        public var queryLanguage: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryLanguage? = null
        /**
         * The query string to use for this definition. For more information, see [CloudWatch Logs Insights Query Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
         */
        public var queryString: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.PutQueryDefinitionRequest) : this() {
            this.clientToken = x.clientToken
            this.logGroupNames = x.logGroupNames
            this.name = x.name
            this.queryDefinitionId = x.queryDefinitionId
            this.queryLanguage = x.queryLanguage
            this.queryString = x.queryString
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.PutQueryDefinitionRequest = PutQueryDefinitionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
