// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutMetricFilterRequest private constructor(builder: Builder) {
    /**
     * This parameter is valid only for log groups that have an active log transformer. For more information about log transformers, see [PutTransformer](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html).
     *
     * If the log group uses either a log-group level or account-level transformer, and you specify `true`, the metric filter will be applied on the transformed version of the log events instead of the original ingested log events.
     */
    public val applyOnTransformedLogs: kotlin.Boolean? = builder.applyOnTransformedLogs
    /**
     * A name for the metric filter.
     */
    public val filterName: kotlin.String? = builder.filterName
    /**
     * A filter pattern for extracting metric data out of ingested log events.
     */
    public val filterPattern: kotlin.String? = builder.filterPattern
    /**
     * The name of the log group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * A collection of information that defines how metric data gets emitted.
     */
    public val metricTransformations: List<MetricTransformation>? = builder.metricTransformations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.PutMetricFilterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutMetricFilterRequest(")
        append("applyOnTransformedLogs=$applyOnTransformedLogs,")
        append("filterName=$filterName,")
        append("filterPattern=$filterPattern,")
        append("logGroupName=$logGroupName,")
        append("metricTransformations=$metricTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyOnTransformedLogs?.hashCode() ?: 0
        result = 31 * result + (filterName?.hashCode() ?: 0)
        result = 31 * result + (filterPattern?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (metricTransformations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutMetricFilterRequest

        if (applyOnTransformedLogs != other.applyOnTransformedLogs) return false
        if (filterName != other.filterName) return false
        if (filterPattern != other.filterPattern) return false
        if (logGroupName != other.logGroupName) return false
        if (metricTransformations != other.metricTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.PutMetricFilterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter is valid only for log groups that have an active log transformer. For more information about log transformers, see [PutTransformer](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html).
         *
         * If the log group uses either a log-group level or account-level transformer, and you specify `true`, the metric filter will be applied on the transformed version of the log events instead of the original ingested log events.
         */
        public var applyOnTransformedLogs: kotlin.Boolean? = null
        /**
         * A name for the metric filter.
         */
        public var filterName: kotlin.String? = null
        /**
         * A filter pattern for extracting metric data out of ingested log events.
         */
        public var filterPattern: kotlin.String? = null
        /**
         * The name of the log group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * A collection of information that defines how metric data gets emitted.
         */
        public var metricTransformations: List<MetricTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.PutMetricFilterRequest) : this() {
            this.applyOnTransformedLogs = x.applyOnTransformedLogs
            this.filterName = x.filterName
            this.filterPattern = x.filterPattern
            this.logGroupName = x.logGroupName
            this.metricTransformations = x.metricTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.PutMetricFilterRequest = PutMetricFilterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
