// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutDeliverySourceRequest private constructor(builder: Builder) {
    /**
     * Defines the type of log that the source is sending.
     * + For Amazon Bedrock, the valid value is `APPLICATION_LOGS`.
     * + For Amazon CodeWhisperer, the valid value is `EVENT_LOGS`.
     * + For IAM Identity Center, the valid value is `ERROR_LOGS`.
     * + For Amazon WorkMail, the valid values are `ACCESS_CONTROL_LOGS`, `AUTHENTICATION_LOGS`, `WORKMAIL_AVAILABILITY_PROVIDER_LOGS`, and `WORKMAIL_MAILBOX_ACCESS_LOGS`.
     */
    public val logType: kotlin.String? = builder.logType
    /**
     * A name for this delivery source. This name must be unique for all delivery sources in your account.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the Amazon Web Services resource that is generating and sending logs. For example, `arn:aws:workmail:us-east-1:123456789012:organization/m-1234EXAMPLEabcd1234abcd1234abcd1234`
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * An optional list of key-value pairs to associate with the resource.
     *
     * For more information about tagging, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDeliverySourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutDeliverySourceRequest(")
        append("logType=$logType,")
        append("name=$name,")
        append("resourceArn=$resourceArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logType?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutDeliverySourceRequest

        if (logType != other.logType) return false
        if (name != other.name) return false
        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDeliverySourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines the type of log that the source is sending.
         * + For Amazon Bedrock, the valid value is `APPLICATION_LOGS`.
         * + For Amazon CodeWhisperer, the valid value is `EVENT_LOGS`.
         * + For IAM Identity Center, the valid value is `ERROR_LOGS`.
         * + For Amazon WorkMail, the valid values are `ACCESS_CONTROL_LOGS`, `AUTHENTICATION_LOGS`, `WORKMAIL_AVAILABILITY_PROVIDER_LOGS`, and `WORKMAIL_MAILBOX_ACCESS_LOGS`.
         */
        public var logType: kotlin.String? = null
        /**
         * A name for this delivery source. This name must be unique for all delivery sources in your account.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the Amazon Web Services resource that is generating and sending logs. For example, `arn:aws:workmail:us-east-1:123456789012:organization/m-1234EXAMPLEabcd1234abcd1234abcd1234`
         */
        public var resourceArn: kotlin.String? = null
        /**
         * An optional list of key-value pairs to associate with the resource.
         *
         * For more information about tagging, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.PutDeliverySourceRequest) : this() {
            this.logType = x.logType
            this.name = x.name
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDeliverySourceRequest = PutDeliverySourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
