// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Use this processor to parse RDS for PostgreSQL vended logs, extract fields, and and convert them into a JSON format. This processor always processes the entire log event message. For more information about this processor including examples, see [ parsePostGres](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres).
 *
 * For more information about RDS for PostgreSQL log format, see [ RDS for PostgreSQL database log filesTCP flag sequence](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.Concepts.PostgreSQL.html#USER_LogAccess.Concepts.PostgreSQL.Log_Format.log-line-prefix).
 *
 * If you use this processor, it must be the first processor in your transformer.
 */
public class ParsePostgres private constructor(builder: Builder) {
    /**
     * Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source`.
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.ParsePostgres = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParsePostgres(")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = source?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParsePostgres

        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.ParsePostgres = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source`.
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.ParsePostgres) : this() {
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.ParsePostgres = ParsePostgres(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
