// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This processor parses a specified field in the original log event into key-value pairs.
 *
 * For more information about this processor including examples, see [ parseKeyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseKeyValue) in the *CloudWatch Logs User Guide*.
 */
public class ParseKeyValue private constructor(builder: Builder) {
    /**
     * The destination field to put the extracted key-value pairs into
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The field delimiter string that is used between key-value pairs in the original log events. If you omit this, the ampersand `&` character is used.
     */
    public val fieldDelimiter: kotlin.String? = builder.fieldDelimiter
    /**
     * If you want to add a prefix to all transformed keys, specify it here.
     */
    public val keyPrefix: kotlin.String? = builder.keyPrefix
    /**
     * The delimiter string to use between the key and value in each pair in the transformed log event.
     *
     *  If you omit this, the equal `=` character is used.
     */
    public val keyValueDelimiter: kotlin.String? = builder.keyValueDelimiter
    /**
     * A value to insert into the value field in the result, when a key-value pair is not successfully split.
     */
    public val nonMatchValue: kotlin.String? = builder.nonMatchValue
    /**
     * Specifies whether to overwrite the value if the destination key already exists. If you omit this, the default is `false`.
     */
    public val overwriteIfExists: kotlin.Boolean = builder.overwriteIfExists
    /**
     * Path to the field in the log event that will be parsed. Use dot notation to access child fields. For example, `store.book`
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.ParseKeyValue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParseKeyValue(")
        append("destination=$destination,")
        append("fieldDelimiter=$fieldDelimiter,")
        append("keyPrefix=$keyPrefix,")
        append("keyValueDelimiter=$keyValueDelimiter,")
        append("nonMatchValue=$nonMatchValue,")
        append("overwriteIfExists=$overwriteIfExists,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (fieldDelimiter?.hashCode() ?: 0)
        result = 31 * result + (keyPrefix?.hashCode() ?: 0)
        result = 31 * result + (keyValueDelimiter?.hashCode() ?: 0)
        result = 31 * result + (nonMatchValue?.hashCode() ?: 0)
        result = 31 * result + (overwriteIfExists.hashCode())
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParseKeyValue

        if (destination != other.destination) return false
        if (fieldDelimiter != other.fieldDelimiter) return false
        if (keyPrefix != other.keyPrefix) return false
        if (keyValueDelimiter != other.keyValueDelimiter) return false
        if (nonMatchValue != other.nonMatchValue) return false
        if (overwriteIfExists != other.overwriteIfExists) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.ParseKeyValue = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The destination field to put the extracted key-value pairs into
         */
        public var destination: kotlin.String? = null
        /**
         * The field delimiter string that is used between key-value pairs in the original log events. If you omit this, the ampersand `&` character is used.
         */
        public var fieldDelimiter: kotlin.String? = null
        /**
         * If you want to add a prefix to all transformed keys, specify it here.
         */
        public var keyPrefix: kotlin.String? = null
        /**
         * The delimiter string to use between the key and value in each pair in the transformed log event.
         *
         *  If you omit this, the equal `=` character is used.
         */
        public var keyValueDelimiter: kotlin.String? = null
        /**
         * A value to insert into the value field in the result, when a key-value pair is not successfully split.
         */
        public var nonMatchValue: kotlin.String? = null
        /**
         * Specifies whether to overwrite the value if the destination key already exists. If you omit this, the default is `false`.
         */
        public var overwriteIfExists: kotlin.Boolean = false
        /**
         * Path to the field in the log event that will be parsed. Use dot notation to access child fields. For example, `store.book`
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.ParseKeyValue) : this() {
            this.destination = x.destination
            this.fieldDelimiter = x.fieldDelimiter
            this.keyPrefix = x.keyPrefix
            this.keyValueDelimiter = x.keyValueDelimiter
            this.nonMatchValue = x.nonMatchValue
            this.overwriteIfExists = x.overwriteIfExists
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.ParseKeyValue = ParseKeyValue(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
