// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This processor parses log events that are in JSON format. It can extract JSON key-value pairs and place them under a destination that you specify.
 *
 * Additionally, because you must have at least one parse-type processor in a transformer, you can use `ParseJSON` as that processor for JSON-format logs, so that you can also apply other processors, such as mutate processors, to these logs.
 *
 * For more information about this processor including examples, see [ parseJSON](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseJSON) in the *CloudWatch Logs User Guide*.
 */
public class ParseJson private constructor(builder: Builder) {
    /**
     * The location to put the parsed key value pair into. If you omit this parameter, it is placed under the root node.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * Path to the field in the log event that will be parsed. Use dot notation to access child fields. For example, `store.book`
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.ParseJson = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParseJson(")
        append("destination=$destination,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParseJson

        if (destination != other.destination) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.ParseJson = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The location to put the parsed key value pair into. If you omit this parameter, it is placed under the root node.
         */
        public var destination: kotlin.String? = null
        /**
         * Path to the field in the log event that will be parsed. Use dot notation to access child fields. For example, `store.book`
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.ParseJson) : this() {
            this.destination = x.destination
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.ParseJson = ParseJson(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
