// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains information about the OpenSearch Service workspace used for this integration. An OpenSearch Service workspace is the collection of dashboards along with other OpenSearch Service tools. This workspace was created automatically as part of the integration setup. For more information, see [Centralized OpenSearch user interface (Dashboards) with OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html).
 */
public class OpenSearchWorkspace private constructor(builder: Builder) {
    /**
     * This structure contains information about the status of an OpenSearch Service resource.
     */
    public val status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = builder.status
    /**
     * The ID of this workspace.
     */
    public val workspaceId: kotlin.String? = builder.workspaceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenSearchWorkspace(")
        append("status=$status,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status?.hashCode() ?: 0
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenSearchWorkspace

        if (status != other.status) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This structure contains information about the status of an OpenSearch Service resource.
         */
        public var status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = null
        /**
         * The ID of this workspace.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace) : this() {
            this.status = x.status
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace = OpenSearchWorkspace(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
