// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch Service.
 */
public class OpenSearchResourceConfig private constructor(builder: Builder) {
    /**
     * If you want to use an existing OpenSearch Service application for your integration with OpenSearch Service, specify it here. If you omit this, a new application will be created.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards.
     *
     * In addition to specifying these users here, you must also grant them the **CloudWatchOpenSearchDashboardsAccess** IAM policy. For more information, see
     */
    public val dashboardViewerPrincipals: List<String> = requireNotNull(builder.dashboardViewerPrincipals) { "A non-null value must be provided for dashboardViewerPrincipals" }
    /**
     * Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This role must have the permissions necessary to access the OpenSearch Service collection to be able to create the dashboards. For more information about the permissions needed, see [Create an IAM role to access the OpenSearch Service collection](https://docs.aws.amazon.com/OpenSearch-Dashboards-CreateRole) in the CloudWatch Logs User Guide.
     */
    public val dataSourceRoleArn: kotlin.String = requireNotNull(builder.dataSourceRoleArn) { "A non-null value must be provided for dataSourceRoleArn" }
    /**
     * To have the vended dashboard data encrypted with KMS instead of the CloudWatch Logs default encryption method, specify the ARN of the KMS key that you want to use.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * Specify how many days that you want the data derived by OpenSearch Service to be retained in the index that the dashboard refers to. This also sets the maximum time period that you can choose when viewing data in the dashboard. Choosing a longer time frame will incur additional costs.
     */
    public val retentionDays: kotlin.Int = requireNotNull(builder.retentionDays) { "A non-null value must be provided for retentionDays" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenSearchResourceConfig(")
        append("applicationArn=$applicationArn,")
        append("dashboardViewerPrincipals=$dashboardViewerPrincipals,")
        append("dataSourceRoleArn=$dataSourceRoleArn,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("retentionDays=$retentionDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn?.hashCode() ?: 0
        result = 31 * result + (dashboardViewerPrincipals.hashCode())
        result = 31 * result + (dataSourceRoleArn.hashCode())
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (retentionDays)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenSearchResourceConfig

        if (applicationArn != other.applicationArn) return false
        if (dashboardViewerPrincipals != other.dashboardViewerPrincipals) return false
        if (dataSourceRoleArn != other.dataSourceRoleArn) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (retentionDays != other.retentionDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If you want to use an existing OpenSearch Service application for your integration with OpenSearch Service, specify it here. If you omit this, a new application will be created.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards.
         *
         * In addition to specifying these users here, you must also grant them the **CloudWatchOpenSearchDashboardsAccess** IAM policy. For more information, see
         */
        public var dashboardViewerPrincipals: List<String>? = null
        /**
         * Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This role must have the permissions necessary to access the OpenSearch Service collection to be able to create the dashboards. For more information about the permissions needed, see [Create an IAM role to access the OpenSearch Service collection](https://docs.aws.amazon.com/OpenSearch-Dashboards-CreateRole) in the CloudWatch Logs User Guide.
         */
        public var dataSourceRoleArn: kotlin.String? = null
        /**
         * To have the vended dashboard data encrypted with KMS instead of the CloudWatch Logs default encryption method, specify the ARN of the KMS key that you want to use.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * Specify how many days that you want the data derived by OpenSearch Service to be retained in the index that the dashboard refers to. This also sets the maximum time period that you can choose when viewing data in the dashboard. Choosing a longer time frame will incur additional costs.
         */
        public var retentionDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceConfig) : this() {
            this.applicationArn = x.applicationArn
            this.dashboardViewerPrincipals = x.dashboardViewerPrincipals
            this.dataSourceRoleArn = x.dataSourceRoleArn
            this.kmsKeyArn = x.kmsKeyArn
            this.retentionDays = x.retentionDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceConfig = OpenSearchResourceConfig(this)

        internal fun correctErrors(): Builder {
            if (dashboardViewerPrincipals == null) dashboardViewerPrincipals = emptyList()
            if (dataSourceRoleArn == null) dataSourceRoleArn = ""
            if (retentionDays == null) retentionDays = 0
            return this
        }
    }
}
