// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains information about the OpenSearch Service data lifecycle policy used for this integration. The lifecycle policy determines the lifespan of the data in the collection. It was automatically created as part of the integration setup.
 *
 * For more information, see [Using data lifecycle policies with OpenSearch Service Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html) in the OpenSearch Service Developer Guide.
 */
public class OpenSearchLifecyclePolicy private constructor(builder: Builder) {
    /**
     * The name of the lifecycle policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * This structure contains information about the status of this OpenSearch Service resource.
     */
    public val status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenSearchLifecyclePolicy(")
        append("policyName=$policyName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyName?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenSearchLifecyclePolicy

        if (policyName != other.policyName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the lifecycle policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * This structure contains information about the status of this OpenSearch Service resource.
         */
        public var status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy) : this() {
            this.policyName = x.policyName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy = OpenSearchLifecyclePolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
