// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains complete information about one CloudWatch Logs integration. This structure is returned by a [GetIntegration](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetIntegration.html) operation.
 */
public class OpenSearchIntegrationDetails private constructor(builder: Builder) {
    /**
     * This structure contains information about the OpenSearch Service data access policy used for this integration. The access policy defines the access controls for the collection. This data access policy was automatically created as part of the integration setup. For more information about OpenSearch Service data access policies, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html) in the OpenSearch Service Developer Guide.
     */
    public val accessPolicy: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy? = builder.accessPolicy
    /**
     * This structure contains information about the OpenSearch Service application used for this integration. An OpenSearch Service application is the web application that was created by the integration with CloudWatch Logs. It hosts the vended logs dashboards.
     */
    public val application: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication? = builder.application
    /**
     * This structure contains information about the OpenSearch Service collection used for this integration. This collection was created as part of the integration setup. An OpenSearch Service collection is a logical grouping of one or more indexes that represent an analytics workload. For more information, see [Creating and managing OpenSearch Service Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-collections.html).
     */
    public val collection: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchCollection? = builder.collection
    /**
     * This structure contains information about the OpenSearch Service data source used for this integration. This data source was created as part of the integration setup. An OpenSearch Service data source defines the source and destination for OpenSearch Service queries. It includes the role required to execute queries and write to collections.
     *
     * For more information about OpenSearch Service data sources , see [Creating OpenSearch Service data source integrations with Amazon S3.](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html)
     */
    public val dataSource: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource? = builder.dataSource
    /**
     * This structure contains information about the OpenSearch Service encryption policy used for this integration. The encryption policy was created automatically when you created the integration. For more information, see [Encryption policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html#serverless-encryption-policies) in the OpenSearch Service Developer Guide.
     */
    public val encryptionPolicy: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchEncryptionPolicy? = builder.encryptionPolicy
    /**
     * This structure contains information about the OpenSearch Service data lifecycle policy used for this integration. The lifecycle policy determines the lifespan of the data in the collection. It was automatically created as part of the integration setup.
     *
     * For more information, see [Using data lifecycle policies with OpenSearch Service Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html) in the OpenSearch Service Developer Guide.
     */
    public val lifecyclePolicy: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy? = builder.lifecyclePolicy
    /**
     * This structure contains information about the OpenSearch Service network policy used for this integration. The network policy assigns network access settings to collections. For more information, see [Network policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies) in the OpenSearch Service Developer Guide.
     */
    public val networkPolicy: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchNetworkPolicy? = builder.networkPolicy
    /**
     * This structure contains information about the OpenSearch Service workspace used for this integration. An OpenSearch Service workspace is the collection of dashboards along with other OpenSearch Service tools. This workspace was created automatically as part of the integration setup. For more information, see [Centralized OpenSearch user interface (Dashboards) with OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html).
     */
    public val workspace: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace? = builder.workspace

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchIntegrationDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenSearchIntegrationDetails(")
        append("accessPolicy=$accessPolicy,")
        append("application=$application,")
        append("collection=$collection,")
        append("dataSource=$dataSource,")
        append("encryptionPolicy=$encryptionPolicy,")
        append("lifecyclePolicy=$lifecyclePolicy,")
        append("networkPolicy=$networkPolicy,")
        append("workspace=$workspace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicy?.hashCode() ?: 0
        result = 31 * result + (application?.hashCode() ?: 0)
        result = 31 * result + (collection?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (encryptionPolicy?.hashCode() ?: 0)
        result = 31 * result + (lifecyclePolicy?.hashCode() ?: 0)
        result = 31 * result + (networkPolicy?.hashCode() ?: 0)
        result = 31 * result + (workspace?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenSearchIntegrationDetails

        if (accessPolicy != other.accessPolicy) return false
        if (application != other.application) return false
        if (collection != other.collection) return false
        if (dataSource != other.dataSource) return false
        if (encryptionPolicy != other.encryptionPolicy) return false
        if (lifecyclePolicy != other.lifecyclePolicy) return false
        if (networkPolicy != other.networkPolicy) return false
        if (workspace != other.workspace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchIntegrationDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This structure contains information about the OpenSearch Service data access policy used for this integration. The access policy defines the access controls for the collection. This data access policy was automatically created as part of the integration setup. For more information about OpenSearch Service data access policies, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html) in the OpenSearch Service Developer Guide.
         */
        public var accessPolicy: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy? = null
        /**
         * This structure contains information about the OpenSearch Service application used for this integration. An OpenSearch Service application is the web application that was created by the integration with CloudWatch Logs. It hosts the vended logs dashboards.
         */
        public var application: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication? = null
        /**
         * This structure contains information about the OpenSearch Service collection used for this integration. This collection was created as part of the integration setup. An OpenSearch Service collection is a logical grouping of one or more indexes that represent an analytics workload. For more information, see [Creating and managing OpenSearch Service Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-collections.html).
         */
        public var collection: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchCollection? = null
        /**
         * This structure contains information about the OpenSearch Service data source used for this integration. This data source was created as part of the integration setup. An OpenSearch Service data source defines the source and destination for OpenSearch Service queries. It includes the role required to execute queries and write to collections.
         *
         * For more information about OpenSearch Service data sources , see [Creating OpenSearch Service data source integrations with Amazon S3.](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html)
         */
        public var dataSource: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource? = null
        /**
         * This structure contains information about the OpenSearch Service encryption policy used for this integration. The encryption policy was created automatically when you created the integration. For more information, see [Encryption policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html#serverless-encryption-policies) in the OpenSearch Service Developer Guide.
         */
        public var encryptionPolicy: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchEncryptionPolicy? = null
        /**
         * This structure contains information about the OpenSearch Service data lifecycle policy used for this integration. The lifecycle policy determines the lifespan of the data in the collection. It was automatically created as part of the integration setup.
         *
         * For more information, see [Using data lifecycle policies with OpenSearch Service Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html) in the OpenSearch Service Developer Guide.
         */
        public var lifecyclePolicy: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy? = null
        /**
         * This structure contains information about the OpenSearch Service network policy used for this integration. The network policy assigns network access settings to collections. For more information, see [Network policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies) in the OpenSearch Service Developer Guide.
         */
        public var networkPolicy: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchNetworkPolicy? = null
        /**
         * This structure contains information about the OpenSearch Service workspace used for this integration. An OpenSearch Service workspace is the collection of dashboards along with other OpenSearch Service tools. This workspace was created automatically as part of the integration setup. For more information, see [Centralized OpenSearch user interface (Dashboards) with OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html).
         */
        public var workspace: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchIntegrationDetails) : this() {
            this.accessPolicy = x.accessPolicy
            this.application = x.application
            this.collection = x.collection
            this.dataSource = x.dataSource
            this.encryptionPolicy = x.encryptionPolicy
            this.lifecyclePolicy = x.lifecyclePolicy
            this.networkPolicy = x.networkPolicy
            this.workspace = x.workspace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchIntegrationDetails = OpenSearchIntegrationDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy] inside the given [block]
         */
        public fun accessPolicy(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy.Builder.() -> kotlin.Unit) {
            this.accessPolicy = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication] inside the given [block]
         */
        public fun application(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication.Builder.() -> kotlin.Unit) {
            this.application = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchCollection] inside the given [block]
         */
        public fun collection(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchCollection.Builder.() -> kotlin.Unit) {
            this.collection = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchCollection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchEncryptionPolicy] inside the given [block]
         */
        public fun encryptionPolicy(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchEncryptionPolicy.Builder.() -> kotlin.Unit) {
            this.encryptionPolicy = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchEncryptionPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy] inside the given [block]
         */
        public fun lifecyclePolicy(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy.Builder.() -> kotlin.Unit) {
            this.lifecyclePolicy = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchLifecyclePolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchNetworkPolicy] inside the given [block]
         */
        public fun networkPolicy(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchNetworkPolicy.Builder.() -> kotlin.Unit) {
            this.networkPolicy = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchNetworkPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace] inside the given [block]
         */
        public fun workspace(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace.Builder.() -> kotlin.Unit) {
            this.workspace = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchWorkspace.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
