// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains information about the OpenSearch Service data source used for this integration. This data source was created as part of the integration setup. An OpenSearch Service data source defines the source and destination for OpenSearch Service queries. It includes the role required to execute queries and write to collections.
 *
 * For more information about OpenSearch Service data sources , see [Creating OpenSearch Service data source integrations with Amazon S3.](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html)
 */
public class OpenSearchDataSource private constructor(builder: Builder) {
    /**
     * The name of the OpenSearch Service data source.
     */
    public val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * This structure contains information about the status of this OpenSearch Service resource.
     */
    public val status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenSearchDataSource(")
        append("dataSourceName=$dataSourceName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceName?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenSearchDataSource

        if (dataSourceName != other.dataSourceName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the OpenSearch Service data source.
         */
        public var dataSourceName: kotlin.String? = null
        /**
         * This structure contains information about the status of this OpenSearch Service resource.
         */
        public var status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource) : this() {
            this.dataSourceName = x.dataSourceName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataSource = OpenSearchDataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
