// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains information about the OpenSearch Service data access policy used for this integration. The access policy defines the access controls for the collection. This data access policy was automatically created as part of the integration setup. For more information about OpenSearch Service data access policies, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html) in the OpenSearch Service Developer Guide.
 */
public class OpenSearchDataAccessPolicy private constructor(builder: Builder) {
    /**
     * The name of the data access policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * This structure contains information about the status of this OpenSearch Service resource.
     */
    public val status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenSearchDataAccessPolicy(")
        append("policyName=$policyName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyName?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenSearchDataAccessPolicy

        if (policyName != other.policyName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the data access policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * This structure contains information about the status of this OpenSearch Service resource.
         */
        public var status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy) : this() {
            this.policyName = x.policyName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchDataAccessPolicy = OpenSearchDataAccessPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
