// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains information about the OpenSearch Service application used for this integration. An OpenSearch Service application is the web application created by the integration with CloudWatch Logs. It hosts the vended logs dashboards.
 */
public class OpenSearchApplication private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The endpoint of the application.
     */
    public val applicationEndpoint: kotlin.String? = builder.applicationEndpoint
    /**
     * The ID of the application.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * This structure contains information about the status of this OpenSearch Service resource.
     */
    public val status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenSearchApplication(")
        append("applicationArn=$applicationArn,")
        append("applicationEndpoint=$applicationEndpoint,")
        append("applicationId=$applicationId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn?.hashCode() ?: 0
        result = 31 * result + (applicationEndpoint?.hashCode() ?: 0)
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenSearchApplication

        if (applicationArn != other.applicationArn) return false
        if (applicationEndpoint != other.applicationEndpoint) return false
        if (applicationId != other.applicationId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The endpoint of the application.
         */
        public var applicationEndpoint: kotlin.String? = null
        /**
         * The ID of the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * This structure contains information about the status of this OpenSearch Service resource.
         */
        public var status: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication) : this() {
            this.applicationArn = x.applicationArn
            this.applicationEndpoint = x.applicationEndpoint
            this.applicationId = x.applicationId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchApplication = OpenSearchApplication(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.cloudwatchlogs.model.OpenSearchResourceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
