// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a log stream, which is a sequence of log events from a single emitter of logs.
 */
public class LogStream private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the log stream.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The creation time of the stream, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
     */
    public val creationTime: kotlin.Long? = builder.creationTime
    /**
     * The time of the first event, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
     */
    public val firstEventTimestamp: kotlin.Long? = builder.firstEventTimestamp
    /**
     * The time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. The `lastEventTime` value updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.
     */
    public val lastEventTimestamp: kotlin.Long? = builder.lastEventTimestamp
    /**
     * The ingestion time, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC` The `lastIngestionTime` value updates on an eventual consistency basis. It typically updates in less than an hour after ingestion, but in rare situations might take longer.
     */
    public val lastIngestionTime: kotlin.Long? = builder.lastIngestionTime
    /**
     * The name of the log stream.
     */
    public val logStreamName: kotlin.String? = builder.logStreamName
    /**
     * The number of bytes stored.
     *
     * **Important:** As of June 17, 2019, this parameter is no longer supported for log streams, and is always reported as zero. This change applies only to log streams. The `storedBytes` parameter for log groups is not affected.
     */
    @Deprecated("Starting on June 17, 2019, this parameter will be deprecated for log streams, and will be reported as zero. This change applies only to log streams. The storedBytes parameter for log groups is not affected.")
    public val storedBytes: kotlin.Long? = builder.storedBytes
    /**
     * The sequence token.
     *
     * The sequence token is now ignored in `PutLogEvents` actions. `PutLogEvents` actions are always accepted regardless of receiving an invalid sequence token. You don't need to obtain `uploadSequenceToken` to use a `PutLogEvents` action.
     */
    public val uploadSequenceToken: kotlin.String? = builder.uploadSequenceToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.LogStream = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogStream(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("firstEventTimestamp=$firstEventTimestamp,")
        append("lastEventTimestamp=$lastEventTimestamp,")
        append("lastIngestionTime=$lastIngestionTime,")
        append("logStreamName=$logStreamName,")
        append("storedBytes=$storedBytes,")
        append("uploadSequenceToken=$uploadSequenceToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (firstEventTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastEventTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastIngestionTime?.hashCode() ?: 0)
        result = 31 * result + (logStreamName?.hashCode() ?: 0)
        result = 31 * result + (storedBytes?.hashCode() ?: 0)
        result = 31 * result + (uploadSequenceToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogStream

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (firstEventTimestamp != other.firstEventTimestamp) return false
        if (lastEventTimestamp != other.lastEventTimestamp) return false
        if (lastIngestionTime != other.lastIngestionTime) return false
        if (logStreamName != other.logStreamName) return false
        if (storedBytes != other.storedBytes) return false
        if (uploadSequenceToken != other.uploadSequenceToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.LogStream = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the log stream.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time of the stream, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
         */
        public var creationTime: kotlin.Long? = null
        /**
         * The time of the first event, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
         */
        public var firstEventTimestamp: kotlin.Long? = null
        /**
         * The time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. The `lastEventTime` value updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.
         */
        public var lastEventTimestamp: kotlin.Long? = null
        /**
         * The ingestion time, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC` The `lastIngestionTime` value updates on an eventual consistency basis. It typically updates in less than an hour after ingestion, but in rare situations might take longer.
         */
        public var lastIngestionTime: kotlin.Long? = null
        /**
         * The name of the log stream.
         */
        public var logStreamName: kotlin.String? = null
        /**
         * The number of bytes stored.
         *
         * **Important:** As of June 17, 2019, this parameter is no longer supported for log streams, and is always reported as zero. This change applies only to log streams. The `storedBytes` parameter for log groups is not affected.
         */
        @Deprecated("Starting on June 17, 2019, this parameter will be deprecated for log streams, and will be reported as zero. This change applies only to log streams. The storedBytes parameter for log groups is not affected.")
        public var storedBytes: kotlin.Long? = null
        /**
         * The sequence token.
         *
         * The sequence token is now ignored in `PutLogEvents` actions. `PutLogEvents` actions are always accepted regardless of receiving an invalid sequence token. You don't need to obtain `uploadSequenceToken` to use a `PutLogEvents` action.
         */
        public var uploadSequenceToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.LogStream) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.firstEventTimestamp = x.firstEventTimestamp
            this.lastEventTimestamp = x.lastEventTimestamp
            this.lastIngestionTime = x.lastIngestionTime
            this.logStreamName = x.logStreamName
            this.storedBytes = x.storedBytes
            this.uploadSequenceToken = x.uploadSequenceToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.LogStream = LogStream(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
