// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a log group.
 */
public class LogGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the log group. This version of the ARN includes a trailing `:*` after the log group name.
     *
     * Use this version to refer to the ARN in IAM policies when specifying permissions for most API actions. The exception is when specifying permissions for [TagResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html), [UntagResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html), and [ListTagsForResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html). The permissions for those three actions require the ARN version that doesn't include a trailing `:*`.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The creation time of the log group, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
     */
    public val creationTime: kotlin.Long? = builder.creationTime
    /**
     * Displays whether this log group has a protection policy, or whether it had one in the past. For more information, see [PutDataProtectionPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html).
     */
    public val dataProtectionStatus: aws.sdk.kotlin.services.cloudwatchlogs.model.DataProtectionStatus? = builder.dataProtectionStatus
    /**
     * Displays all the properties that this log group has inherited from account-level settings.
     */
    public val inheritedProperties: List<InheritedProperty>? = builder.inheritedProperties
    /**
     * The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon Resource Name (ARN) of the log group. This version of the ARN doesn't include a trailing `:*` after the log group name.
     *
     * Use this version to refer to the ARN in the following situations:
     * + In the `logGroupIdentifier` input field in many CloudWatch Logs APIs.
     * + In the `resourceArn` field in tagging APIs
     * + In IAM policies, when specifying permissions for [TagResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html), [UntagResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html), and [ListTagsForResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html).
     */
    public val logGroupArn: kotlin.String? = builder.logGroupArn
    /**
     * This specifies the log group class for this log group. There are two classes:
     * + The `Standard` log class supports all CloudWatch Logs features.
     * + The `Infrequent Access` log class supports a subset of CloudWatch Logs features and incurs lower costs.
     *
     * For details about the features supported by each class, see [Log classes](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html)
     */
    public val logGroupClass: aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroupClass? = builder.logGroupClass
    /**
     * The name of the log group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The number of metric filters.
     */
    public val metricFilterCount: kotlin.Int? = builder.metricFilterCount
    /**
     * The number of days to retain the log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, and 3653.
     *
     * To set a log group so that its log events do not expire, use [DeleteRetentionPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html).
     */
    public val retentionInDays: kotlin.Int? = builder.retentionInDays
    /**
     * The number of bytes stored.
     */
    public val storedBytes: kotlin.Long? = builder.storedBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogGroup(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("dataProtectionStatus=$dataProtectionStatus,")
        append("inheritedProperties=$inheritedProperties,")
        append("kmsKeyId=$kmsKeyId,")
        append("logGroupArn=$logGroupArn,")
        append("logGroupClass=$logGroupClass,")
        append("logGroupName=$logGroupName,")
        append("metricFilterCount=$metricFilterCount,")
        append("retentionInDays=$retentionInDays,")
        append("storedBytes=$storedBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataProtectionStatus?.hashCode() ?: 0)
        result = 31 * result + (inheritedProperties?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logGroupArn?.hashCode() ?: 0)
        result = 31 * result + (logGroupClass?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (metricFilterCount ?: 0)
        result = 31 * result + (retentionInDays ?: 0)
        result = 31 * result + (storedBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogGroup

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (dataProtectionStatus != other.dataProtectionStatus) return false
        if (inheritedProperties != other.inheritedProperties) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logGroupArn != other.logGroupArn) return false
        if (logGroupClass != other.logGroupClass) return false
        if (logGroupName != other.logGroupName) return false
        if (metricFilterCount != other.metricFilterCount) return false
        if (retentionInDays != other.retentionInDays) return false
        if (storedBytes != other.storedBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the log group. This version of the ARN includes a trailing `:*` after the log group name.
         *
         * Use this version to refer to the ARN in IAM policies when specifying permissions for most API actions. The exception is when specifying permissions for [TagResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html), [UntagResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html), and [ListTagsForResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html). The permissions for those three actions require the ARN version that doesn't include a trailing `:*`.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time of the log group, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         */
        public var creationTime: kotlin.Long? = null
        /**
         * Displays whether this log group has a protection policy, or whether it had one in the past. For more information, see [PutDataProtectionPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html).
         */
        public var dataProtectionStatus: aws.sdk.kotlin.services.cloudwatchlogs.model.DataProtectionStatus? = null
        /**
         * Displays all the properties that this log group has inherited from account-level settings.
         */
        public var inheritedProperties: List<InheritedProperty>? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the log group. This version of the ARN doesn't include a trailing `:*` after the log group name.
         *
         * Use this version to refer to the ARN in the following situations:
         * + In the `logGroupIdentifier` input field in many CloudWatch Logs APIs.
         * + In the `resourceArn` field in tagging APIs
         * + In IAM policies, when specifying permissions for [TagResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html), [UntagResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html), and [ListTagsForResource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html).
         */
        public var logGroupArn: kotlin.String? = null
        /**
         * This specifies the log group class for this log group. There are two classes:
         * + The `Standard` log class supports all CloudWatch Logs features.
         * + The `Infrequent Access` log class supports a subset of CloudWatch Logs features and incurs lower costs.
         *
         * For details about the features supported by each class, see [Log classes](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html)
         */
        public var logGroupClass: aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroupClass? = null
        /**
         * The name of the log group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The number of metric filters.
         */
        public var metricFilterCount: kotlin.Int? = null
        /**
         * The number of days to retain the log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, and 3653.
         *
         * To set a log group so that its log events do not expire, use [DeleteRetentionPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html).
         */
        public var retentionInDays: kotlin.Int? = null
        /**
         * The number of bytes stored.
         */
        public var storedBytes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroup) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.dataProtectionStatus = x.dataProtectionStatus
            this.inheritedProperties = x.inheritedProperties
            this.kmsKeyId = x.kmsKeyId
            this.logGroupArn = x.logGroupArn
            this.logGroupClass = x.logGroupClass
            this.logGroupName = x.logGroupName
            this.metricFilterCount = x.metricFilterCount
            this.retentionInDays = x.retentionInDays
            this.storedBytes = x.storedBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroup = LogGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
