// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This processor takes a list of objects that contain key fields, and converts them into a map of target keys.
 *
 * For more information about this processor including examples, see [ listToMap](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap) in the *CloudWatch Logs User Guide*.
 */
public class ListToMap private constructor(builder: Builder) {
    /**
     * A Boolean value to indicate whether the list will be flattened into single items. Specify `true` to flatten the list. The default is `false`
     */
    public val flatten: kotlin.Boolean = builder.flatten
    /**
     * If you set `flatten` to `true`, use `flattenedElement` to specify which element, `first` or `last`, to keep.
     *
     * You must specify this parameter if `flatten` is `true`
     */
    public val flattenedElement: aws.sdk.kotlin.services.cloudwatchlogs.model.FlattenedElement? = builder.flattenedElement
    /**
     * The key of the field to be extracted as keys in the generated map
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The key in the log event that has a list of objects that will be converted to a map.
     */
    public val source: kotlin.String = requireNotNull(builder.source) { "A non-null value must be provided for source" }
    /**
     * The key of the field that will hold the generated map
     */
    public val target: kotlin.String? = builder.target
    /**
     * If this is specified, the values that you specify in this parameter will be extracted from the `source` objects and put into the values of the generated map. Otherwise, original objects in the source list will be put into the values of the generated map.
     */
    public val valueKey: kotlin.String? = builder.valueKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.ListToMap = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListToMap(")
        append("flatten=$flatten,")
        append("flattenedElement=$flattenedElement,")
        append("key=$key,")
        append("source=$source,")
        append("target=$target,")
        append("valueKey=$valueKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = flatten.hashCode()
        result = 31 * result + (flattenedElement?.hashCode() ?: 0)
        result = 31 * result + (key.hashCode())
        result = 31 * result + (source.hashCode())
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (valueKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListToMap

        if (flatten != other.flatten) return false
        if (flattenedElement != other.flattenedElement) return false
        if (key != other.key) return false
        if (source != other.source) return false
        if (target != other.target) return false
        if (valueKey != other.valueKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.ListToMap = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean value to indicate whether the list will be flattened into single items. Specify `true` to flatten the list. The default is `false`
         */
        public var flatten: kotlin.Boolean = false
        /**
         * If you set `flatten` to `true`, use `flattenedElement` to specify which element, `first` or `last`, to keep.
         *
         * You must specify this parameter if `flatten` is `true`
         */
        public var flattenedElement: aws.sdk.kotlin.services.cloudwatchlogs.model.FlattenedElement? = null
        /**
         * The key of the field to be extracted as keys in the generated map
         */
        public var key: kotlin.String? = null
        /**
         * The key in the log event that has a list of objects that will be converted to a map.
         */
        public var source: kotlin.String? = null
        /**
         * The key of the field that will hold the generated map
         */
        public var target: kotlin.String? = null
        /**
         * If this is specified, the values that you specify in this parameter will be extracted from the `source` objects and put into the values of the generated map. Otherwise, original objects in the source list will be put into the values of the generated map.
         */
        public var valueKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.ListToMap) : this() {
            this.flatten = x.flatten
            this.flattenedElement = x.flattenedElement
            this.key = x.key
            this.source = x.source
            this.target = x.target
            this.valueKey = x.valueKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.ListToMap = ListToMap(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (source == null) source = ""
            return this
        }
    }
}
