// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetQueryResultsResponse private constructor(builder: Builder) {
    /**
     * If you associated an KMS key with the CloudWatch Logs Insights query results in this account, this field displays the ARN of the key that's used to encrypt the query results when [StartQuery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html) stores them.
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The query language used for this query. For more information about the query languages that CloudWatch Logs supports, see [Supported query languages](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html).
     */
    public val queryLanguage: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryLanguage? = builder.queryLanguage
    /**
     * The log events that matched the query criteria during the most recent time it ran.
     *
     * The `results` value is an array of arrays. Each log event is one object in the top-level array. Each of these log event objects is an array of `field`/`value` pairs.
     */
    public val results: List<List<ResultField>>? = builder.results
    /**
     * Includes the number of log events scanned by the query, the number of log events that matched the query criteria, and the total number of bytes in the scanned log events. These values reflect the full raw results of the query.
     */
    public val statistics: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics? = builder.statistics
    /**
     * The status of the most recent running of the query. Possible values are `Cancelled`, `Complete`, `Failed`, `Running`, `Scheduled`, `Timeout`, and `Unknown`.
     *
     * Queries time out after 60 minutes of runtime. To avoid having your queries time out, reduce the time range being searched or partition your query into a number of queries.
     */
    public val status: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.GetQueryResultsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetQueryResultsResponse(")
        append("encryptionKey=$encryptionKey,")
        append("queryLanguage=$queryLanguage,")
        append("results=$results,")
        append("statistics=$statistics,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionKey?.hashCode() ?: 0
        result = 31 * result + (queryLanguage?.hashCode() ?: 0)
        result = 31 * result + (results?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetQueryResultsResponse

        if (encryptionKey != other.encryptionKey) return false
        if (queryLanguage != other.queryLanguage) return false
        if (results != other.results) return false
        if (statistics != other.statistics) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.GetQueryResultsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If you associated an KMS key with the CloudWatch Logs Insights query results in this account, this field displays the ARN of the key that's used to encrypt the query results when [StartQuery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html) stores them.
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * The query language used for this query. For more information about the query languages that CloudWatch Logs supports, see [Supported query languages](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html).
         */
        public var queryLanguage: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryLanguage? = null
        /**
         * The log events that matched the query criteria during the most recent time it ran.
         *
         * The `results` value is an array of arrays. Each log event is one object in the top-level array. Each of these log event objects is an array of `field`/`value` pairs.
         */
        public var results: List<List<ResultField>>? = null
        /**
         * Includes the number of log events scanned by the query, the number of log events that matched the query criteria, and the total number of bytes in the scanned log events. These values reflect the full raw results of the query.
         */
        public var statistics: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics? = null
        /**
         * The status of the most recent running of the query. Possible values are `Cancelled`, `Complete`, `Failed`, `Running`, `Scheduled`, `Timeout`, and `Unknown`.
         *
         * Queries time out after 60 minutes of runtime. To avoid having your queries time out, reduce the time range being searched or partition your query into a number of queries.
         */
        public var status: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.GetQueryResultsResponse) : this() {
            this.encryptionKey = x.encryptionKey
            this.queryLanguage = x.queryLanguage
            this.results = x.results
            this.statistics = x.statistics
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.GetQueryResultsResponse = GetQueryResultsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics] inside the given [block]
         */
        public fun statistics(block: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics.Builder.() -> kotlin.Unit) {
            this.statistics = aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
