// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure describes one log event field that is used as an index in at least one index policy in this account.
 */
public class FieldIndex private constructor(builder: Builder) {
    /**
     * The string that this field index matches.
     */
    public val fieldIndexName: kotlin.String? = builder.fieldIndexName
    /**
     * The time and date of the earliest log event that matches this field index, after the index policy that contains it was created.
     */
    public val firstEventTime: kotlin.Long? = builder.firstEventTime
    /**
     * The time and date of the most recent log event that matches this field index.
     */
    public val lastEventTime: kotlin.Long? = builder.lastEventTime
    /**
     * The most recent time that CloudWatch Logs scanned ingested log events to search for this field index to improve the speed of future CloudWatch Logs Insights queries that search for this field index.
     */
    public val lastScanTime: kotlin.Long? = builder.lastScanTime
    /**
     * If this field index appears in an index policy that applies only to a single log group, the ARN of that log group is displayed here.
     */
    public val logGroupIdentifier: kotlin.String? = builder.logGroupIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.FieldIndex = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FieldIndex(")
        append("fieldIndexName=$fieldIndexName,")
        append("firstEventTime=$firstEventTime,")
        append("lastEventTime=$lastEventTime,")
        append("lastScanTime=$lastScanTime,")
        append("logGroupIdentifier=$logGroupIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldIndexName?.hashCode() ?: 0
        result = 31 * result + (firstEventTime?.hashCode() ?: 0)
        result = 31 * result + (lastEventTime?.hashCode() ?: 0)
        result = 31 * result + (lastScanTime?.hashCode() ?: 0)
        result = 31 * result + (logGroupIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FieldIndex

        if (fieldIndexName != other.fieldIndexName) return false
        if (firstEventTime != other.firstEventTime) return false
        if (lastEventTime != other.lastEventTime) return false
        if (lastScanTime != other.lastScanTime) return false
        if (logGroupIdentifier != other.logGroupIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.FieldIndex = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The string that this field index matches.
         */
        public var fieldIndexName: kotlin.String? = null
        /**
         * The time and date of the earliest log event that matches this field index, after the index policy that contains it was created.
         */
        public var firstEventTime: kotlin.Long? = null
        /**
         * The time and date of the most recent log event that matches this field index.
         */
        public var lastEventTime: kotlin.Long? = null
        /**
         * The most recent time that CloudWatch Logs scanned ingested log events to search for this field index to improve the speed of future CloudWatch Logs Insights queries that search for this field index.
         */
        public var lastScanTime: kotlin.Long? = null
        /**
         * If this field index appears in an index policy that applies only to a single log group, the ARN of that log group is displayed here.
         */
        public var logGroupIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.FieldIndex) : this() {
            this.fieldIndexName = x.fieldIndexName
            this.firstEventTime = x.firstEventTime
            this.lastEventTime = x.lastEventTime
            this.lastScanTime = x.lastScanTime
            this.logGroupIdentifier = x.logGroupIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.FieldIndex = FieldIndex(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
