// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The entity associated with the log events in a `PutLogEvents` call.
 */
public class Entity private constructor(builder: Builder) {
    /**
     * Additional attributes of the entity that are not used to specify the identity of the entity. A list of key-value pairs.
     *
     * For details about how to use the attributes, see [How to add related information to telemetry](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/adding-your-own-related-telemetry.html) in the *CloudWatch User Guide*.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The attributes of the entity which identify the specific entity, as a list of key-value pairs. Entities with the same `keyAttributes` are considered to be the same entity.
     *
     * There are five allowed attributes (key names): `Type`, `ResourceType`, `Identifier``Name`, and `Environment`.
     *
     * For details about how to use the key attributes, see [How to add related information to telemetry](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/adding-your-own-related-telemetry.html) in the *CloudWatch User Guide*.
     */
    public val keyAttributes: Map<String, String>? = builder.keyAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.Entity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Entity(")
        append("attributes=$attributes,")
        append("keyAttributes=$keyAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (keyAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Entity

        if (attributes != other.attributes) return false
        if (keyAttributes != other.keyAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.Entity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional attributes of the entity that are not used to specify the identity of the entity. A list of key-value pairs.
         *
         * For details about how to use the attributes, see [How to add related information to telemetry](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/adding-your-own-related-telemetry.html) in the *CloudWatch User Guide*.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The attributes of the entity which identify the specific entity, as a list of key-value pairs. Entities with the same `keyAttributes` are considered to be the same entity.
         *
         * There are five allowed attributes (key names): `Type`, `ResourceType`, `Identifier``Name`, and `Environment`.
         *
         * For details about how to use the key attributes, see [How to add related information to telemetry](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/adding-your-own-related-telemetry.html) in the *CloudWatch User Guide*.
         */
        public var keyAttributes: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.Entity) : this() {
            this.attributes = x.attributes
            this.keyAttributes = x.keyAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.Entity = Entity(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
