// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains information about one *delivery destination* in your account. A delivery destination is an Amazon Web Services resource that represents an Amazon Web Services service that logs can be sent to. CloudWatch Logs, Amazon S3, are supported as Firehose delivery destinations.
 *
 * To configure logs delivery between a supported Amazon Web Services service and a destination, you must do the following:
 * + Create a delivery source, which is a logical object that represents the resource that is actually sending the logs. For more information, see [PutDeliverySource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html).
 * + Create a *delivery destination*, which is a logical object that represents the actual delivery destination.
 * + If you are delivering logs cross-account, you must use [PutDeliveryDestinationPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html) in the destination account to assign an IAM policy to the destination. This policy allows delivery to that destination.
 * + Create a *delivery* by pairing exactly one delivery source and one delivery destination. For more information, see [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html).
 *
 * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries. You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery destination.
 */
public class DeliveryDestination private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies this delivery destination.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A structure that contains the ARN of the Amazon Web Services resource that will receive the logs.
     */
    public val deliveryDestinationConfiguration: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationConfiguration? = builder.deliveryDestinationConfiguration
    /**
     * Displays whether this delivery destination is CloudWatch Logs, Amazon S3, or Firehose.
     */
    public val deliveryDestinationType: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationType? = builder.deliveryDestinationType
    /**
     * The name of this delivery destination.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The format of the logs that are sent to this delivery destination.
     */
    public val outputFormat: aws.sdk.kotlin.services.cloudwatchlogs.model.OutputFormat? = builder.outputFormat
    /**
     * The tags that have been assigned to this delivery destination.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeliveryDestination(")
        append("arn=$arn,")
        append("deliveryDestinationConfiguration=$deliveryDestinationConfiguration,")
        append("deliveryDestinationType=$deliveryDestinationType,")
        append("name=$name,")
        append("outputFormat=$outputFormat,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (deliveryDestinationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deliveryDestinationType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeliveryDestination

        if (arn != other.arn) return false
        if (deliveryDestinationConfiguration != other.deliveryDestinationConfiguration) return false
        if (deliveryDestinationType != other.deliveryDestinationType) return false
        if (name != other.name) return false
        if (outputFormat != other.outputFormat) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies this delivery destination.
         */
        public var arn: kotlin.String? = null
        /**
         * A structure that contains the ARN of the Amazon Web Services resource that will receive the logs.
         */
        public var deliveryDestinationConfiguration: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationConfiguration? = null
        /**
         * Displays whether this delivery destination is CloudWatch Logs, Amazon S3, or Firehose.
         */
        public var deliveryDestinationType: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationType? = null
        /**
         * The name of this delivery destination.
         */
        public var name: kotlin.String? = null
        /**
         * The format of the logs that are sent to this delivery destination.
         */
        public var outputFormat: aws.sdk.kotlin.services.cloudwatchlogs.model.OutputFormat? = null
        /**
         * The tags that have been assigned to this delivery destination.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestination) : this() {
            this.arn = x.arn
            this.deliveryDestinationConfiguration = x.deliveryDestinationConfiguration
            this.deliveryDestinationType = x.deliveryDestinationType
            this.name = x.name
            this.outputFormat = x.outputFormat
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestination = DeliveryDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationConfiguration] inside the given [block]
         */
        public fun deliveryDestinationConfiguration(block: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.deliveryDestinationConfiguration = aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
