// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This processor converts a datetime string into a format that you specify.
 *
 * For more information about this processor including examples, see [ datetimeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-datetimeConverter) in the *CloudWatch Logs User Guide*.
 */
public class DateTimeConverter private constructor(builder: Builder) {
    /**
     * The locale of the source field. If you omit this, the default of `locale.ROOT` is used.
     */
    public val locale: kotlin.String? = builder.locale
    /**
     * A list of patterns to match against the `source` field.
     */
    public val matchPatterns: List<String> = requireNotNull(builder.matchPatterns) { "A non-null value must be provided for matchPatterns" }
    /**
     * The key to apply the date conversion to.
     */
    public val source: kotlin.String = requireNotNull(builder.source) { "A non-null value must be provided for source" }
    /**
     * The time zone of the source field. If you omit this, the default used is the UTC zone.
     */
    public val sourceTimezone: kotlin.String? = builder.sourceTimezone
    /**
     * The JSON field to store the result in.
     */
    public val target: kotlin.String = requireNotNull(builder.target) { "A non-null value must be provided for target" }
    /**
     * The datetime format to use for the converted data in the target field.
     *
     * If you omit this, the default of ` yyyy-MM-dd'T'HH:mm:ss.SSS'Z` is used.
     */
    public val targetFormat: kotlin.String? = builder.targetFormat
    /**
     * The time zone of the target field. If you omit this, the default used is the UTC zone.
     */
    public val targetTimezone: kotlin.String? = builder.targetTimezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.DateTimeConverter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DateTimeConverter(")
        append("locale=$locale,")
        append("matchPatterns=$matchPatterns,")
        append("source=$source,")
        append("sourceTimezone=$sourceTimezone,")
        append("target=$target,")
        append("targetFormat=$targetFormat,")
        append("targetTimezone=$targetTimezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = locale?.hashCode() ?: 0
        result = 31 * result + (matchPatterns.hashCode())
        result = 31 * result + (source.hashCode())
        result = 31 * result + (sourceTimezone?.hashCode() ?: 0)
        result = 31 * result + (target.hashCode())
        result = 31 * result + (targetFormat?.hashCode() ?: 0)
        result = 31 * result + (targetTimezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DateTimeConverter

        if (locale != other.locale) return false
        if (matchPatterns != other.matchPatterns) return false
        if (source != other.source) return false
        if (sourceTimezone != other.sourceTimezone) return false
        if (target != other.target) return false
        if (targetFormat != other.targetFormat) return false
        if (targetTimezone != other.targetTimezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.DateTimeConverter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The locale of the source field. If you omit this, the default of `locale.ROOT` is used.
         */
        public var locale: kotlin.String? = null
        /**
         * A list of patterns to match against the `source` field.
         */
        public var matchPatterns: List<String>? = null
        /**
         * The key to apply the date conversion to.
         */
        public var source: kotlin.String? = null
        /**
         * The time zone of the source field. If you omit this, the default used is the UTC zone.
         */
        public var sourceTimezone: kotlin.String? = null
        /**
         * The JSON field to store the result in.
         */
        public var target: kotlin.String? = null
        /**
         * The datetime format to use for the converted data in the target field.
         *
         * If you omit this, the default of ` yyyy-MM-dd'T'HH:mm:ss.SSS'Z` is used.
         */
        public var targetFormat: kotlin.String? = null
        /**
         * The time zone of the target field. If you omit this, the default used is the UTC zone.
         */
        public var targetTimezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.DateTimeConverter) : this() {
            this.locale = x.locale
            this.matchPatterns = x.matchPatterns
            this.source = x.source
            this.sourceTimezone = x.sourceTimezone
            this.target = x.target
            this.targetFormat = x.targetFormat
            this.targetTimezone = x.targetTimezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.DateTimeConverter = DateTimeConverter(this)

        internal fun correctErrors(): Builder {
            if (matchPatterns == null) matchPatterns = emptyList()
            if (source == null) source = ""
            if (target == null) target = ""
            return this
        }
    }
}
