// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The `CSV` processor parses comma-separated values (CSV) from the log events into columns.
 *
 * For more information about this processor including examples, see [ csv](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-csv) in the *CloudWatch Logs User Guide*.
 */
public class Csv private constructor(builder: Builder) {
    /**
     * An array of names to use for the columns in the transformed log event.
     *
     * If you omit this, default column names (`[column_1, column_2 ...]`) are used.
     */
    public val columns: List<String>? = builder.columns
    /**
     * The character used to separate each column in the original comma-separated value log event. If you omit this, the processor looks for the comma `,` character as the delimiter.
     */
    public val delimiter: kotlin.String? = builder.delimiter
    /**
     * The character used used as a text qualifier for a single column of data. If you omit this, the double quotation mark `"` character is used.
     */
    public val quoteCharacter: kotlin.String? = builder.quoteCharacter
    /**
     * The path to the field in the log event that has the comma separated values to be parsed. If you omit this value, the whole log message is processed.
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.Csv = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Csv(")
        append("columns=$columns,")
        append("delimiter=$delimiter,")
        append("quoteCharacter=$quoteCharacter,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = columns?.hashCode() ?: 0
        result = 31 * result + (delimiter?.hashCode() ?: 0)
        result = 31 * result + (quoteCharacter?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Csv

        if (columns != other.columns) return false
        if (delimiter != other.delimiter) return false
        if (quoteCharacter != other.quoteCharacter) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.Csv = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of names to use for the columns in the transformed log event.
         *
         * If you omit this, default column names (`[column_1, column_2 ...]`) are used.
         */
        public var columns: List<String>? = null
        /**
         * The character used to separate each column in the original comma-separated value log event. If you omit this, the processor looks for the comma `,` character as the delimiter.
         */
        public var delimiter: kotlin.String? = null
        /**
         * The character used used as a text qualifier for a single column of data. If you omit this, the double quotation mark `"` character is used.
         */
        public var quoteCharacter: kotlin.String? = null
        /**
         * The path to the field in the log event that has the comma separated values to be parsed. If you omit this value, the whole log message is processed.
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.Csv) : this() {
            this.columns = x.columns
            this.delimiter = x.delimiter
            this.quoteCharacter = x.quoteCharacter
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.Csv = Csv(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
