// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateLogGroupRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data. For more information, see [Amazon Resource Names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms).
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Use this parameter to specify the log group class for this log group. There are two classes:
     * + The `Standard` log class supports all CloudWatch Logs features.
     * + The `Infrequent Access` log class supports a subset of CloudWatch Logs features and incurs lower costs.
     *
     * If you omit this parameter, the default of `STANDARD` is used.
     *
     * The value of `logGroupClass` can't be changed after a log group is created.
     *
     * For details about the features supported by each class, see [Log classes](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html)
     */
    public val logGroupClass: aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroupClass? = builder.logGroupClass
    /**
     * A name for the log group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The key-value pairs to use for the tags.
     *
     * You can grant users access to certain log groups while preventing them from accessing other log groups. To do so, tag your groups and use IAM policies that refer to those tags. To assign tags when you create a log group, you must have either the `logs:TagResource` or `logs:TagLogGroup` permission. For more information about tagging, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). For more information about using tags to control access, see [Controlling access to Amazon Web Services resources using tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateLogGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLogGroupRequest(")
        append("kmsKeyId=$kmsKeyId,")
        append("logGroupClass=$logGroupClass,")
        append("logGroupName=$logGroupName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (logGroupClass?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLogGroupRequest

        if (kmsKeyId != other.kmsKeyId) return false
        if (logGroupClass != other.logGroupClass) return false
        if (logGroupName != other.logGroupName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateLogGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data. For more information, see [Amazon Resource Names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms).
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Use this parameter to specify the log group class for this log group. There are two classes:
         * + The `Standard` log class supports all CloudWatch Logs features.
         * + The `Infrequent Access` log class supports a subset of CloudWatch Logs features and incurs lower costs.
         *
         * If you omit this parameter, the default of `STANDARD` is used.
         *
         * The value of `logGroupClass` can't be changed after a log group is created.
         *
         * For details about the features supported by each class, see [Log classes](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html)
         */
        public var logGroupClass: aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroupClass? = null
        /**
         * A name for the log group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The key-value pairs to use for the tags.
         *
         * You can grant users access to certain log groups while preventing them from accessing other log groups. To do so, tag your groups and use IAM policies that refer to those tags. To assign tags when you create a log group, you must have either the `logs:TagResource` or `logs:TagLogGroup` permission. For more information about tagging, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). For more information about using tags to control access, see [Controlling access to Amazon Web Services resources using tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.CreateLogGroupRequest) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.logGroupClass = x.logGroupClass
            this.logGroupName = x.logGroupName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateLogGroupRequest = CreateLogGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
