// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This processor copies values within a log event. You can also use this processor to add metadata to log events by copying the values of the following metadata keys into the log events: `@logGroupName`, `@logGroupStream`, `@accountId`, `@regionName`.
 *
 * For more information about this processor including examples, see [ copyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-copyValue) in the *CloudWatch Logs User Guide*.
 */
public class CopyValue private constructor(builder: Builder) {
    /**
     * An array of `CopyValueEntry` objects, where each object contains the information about one field value to copy.
     */
    public val entries: List<CopyValueEntry> = requireNotNull(builder.entries) { "A non-null value must be provided for entries" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.CopyValue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyValue(")
        append("entries=$entries")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = entries.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyValue

        if (entries != other.entries) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.CopyValue = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of `CopyValueEntry` objects, where each object contains the information about one field value to copy.
         */
        public var entries: List<CopyValueEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.CopyValue) : this() {
            this.entries = x.entries
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.CopyValue = CopyValue(this)

        internal fun correctErrors(): Builder {
            if (entries == null) entries = emptyList()
            return this
        }
    }
}
