// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure represents one anomaly that has been found by a logs anomaly detector.
 *
 * For more information about patterns and anomalies, see [CreateLogAnomalyDetector](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateLogAnomalyDetector.html).
 */
public class Anomaly private constructor(builder: Builder) {
    /**
     * Specifies whether this anomaly is still ongoing.
     */
    public val active: kotlin.Boolean = requireNotNull(builder.active) { "A non-null value must be provided for active" }
    /**
     * The ARN of the anomaly detector that identified this anomaly.
     */
    public val anomalyDetectorArn: kotlin.String = requireNotNull(builder.anomalyDetectorArn) { "A non-null value must be provided for anomalyDetectorArn" }
    /**
     * The unique ID that CloudWatch Logs assigned to this anomaly.
     */
    public val anomalyId: kotlin.String = requireNotNull(builder.anomalyId) { "A non-null value must be provided for anomalyId" }
    /**
     * A human-readable description of the anomaly. This description is generated by CloudWatch Logs.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The date and time when the anomaly detector first saw this anomaly. It is specified as epoch time, which is the number of seconds since `January 1, 1970, 00:00:00 UTC`.
     */
    public val firstSeen: kotlin.Long = builder.firstSeen
    /**
     * A map showing times when the anomaly detector ran, and the number of occurrences of this anomaly that were detected at each of those runs. The times are specified in epoch time, which is the number of seconds since `January 1, 1970, 00:00:00 UTC`.
     */
    public val histogram: Map<String, Long> = requireNotNull(builder.histogram) { "A non-null value must be provided for histogram" }
    /**
     * If this anomaly is suppressed, this field is `true` if the suppression is because the pattern is suppressed. If `false`, then only this particular anomaly is suppressed.
     */
    public val isPatternLevelSuppression: kotlin.Boolean? = builder.isPatternLevelSuppression
    /**
     * The date and time when the anomaly detector most recently saw this anomaly. It is specified as epoch time, which is the number of seconds since `January 1, 1970, 00:00:00 UTC`.
     */
    public val lastSeen: kotlin.Long = builder.lastSeen
    /**
     * An array of ARNS of the log groups that contained log events considered to be part of this anomaly.
     */
    public val logGroupArnList: List<String> = requireNotNull(builder.logGroupArnList) { "A non-null value must be provided for logGroupArnList" }
    /**
     * An array of sample log event messages that are considered to be part of this anomaly.
     */
    public val logSamples: List<LogEvent> = requireNotNull(builder.logSamples) { "A non-null value must be provided for logSamples" }
    /**
     * The ID of the pattern used to help identify this anomaly.
     */
    public val patternId: kotlin.String = requireNotNull(builder.patternId) { "A non-null value must be provided for patternId" }
    /**
     * The pattern used to help identify this anomaly, in regular expression format.
     */
    public val patternRegex: kotlin.String? = builder.patternRegex
    /**
     * The pattern used to help identify this anomaly, in string format.
     */
    public val patternString: kotlin.String = requireNotNull(builder.patternString) { "A non-null value must be provided for patternString" }
    /**
     * An array of structures where each structure contains information about one token that makes up the pattern.
     */
    public val patternTokens: List<PatternToken> = requireNotNull(builder.patternTokens) { "A non-null value must be provided for patternTokens" }
    /**
     * The priority level of this anomaly, as determined by CloudWatch Logs. Priority is computed based on log severity labels such as `FATAL` and `ERROR` and the amount of deviation from the baseline. Possible values are `HIGH`, `MEDIUM`, and `LOW`.
     */
    public val priority: kotlin.String? = builder.priority
    /**
     * Indicates the current state of this anomaly. If it is still being treated as an anomaly, the value is `Active`. If you have suppressed this anomaly by using the [UpdateAnomaly](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateAnomaly.html) operation, the value is `Suppressed`. If this behavior is now considered to be normal, the value is `Baseline`.
     */
    public val state: aws.sdk.kotlin.services.cloudwatchlogs.model.State = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * Indicates whether this anomaly is currently suppressed. To suppress an anomaly, use [UpdateAnomaly](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateAnomaly.html).
     */
    public val suppressed: kotlin.Boolean? = builder.suppressed
    /**
     * If the anomaly is suppressed, this indicates when it was suppressed.
     */
    public val suppressedDate: kotlin.Long = builder.suppressedDate
    /**
     * If the anomaly is suppressed, this indicates when the suppression will end. If this value is `0`, the anomaly was suppressed with no expiration, with the `INFINITE` value.
     */
    public val suppressedUntil: kotlin.Long = builder.suppressedUntil

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.Anomaly = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Anomaly(")
        append("active=$active,")
        append("anomalyDetectorArn=$anomalyDetectorArn,")
        append("anomalyId=$anomalyId,")
        append("description=$description,")
        append("firstSeen=$firstSeen,")
        append("histogram=$histogram,")
        append("isPatternLevelSuppression=$isPatternLevelSuppression,")
        append("lastSeen=$lastSeen,")
        append("logGroupArnList=$logGroupArnList,")
        append("logSamples=$logSamples,")
        append("patternId=$patternId,")
        append("patternRegex=$patternRegex,")
        append("patternString=$patternString,")
        append("patternTokens=$patternTokens,")
        append("priority=$priority,")
        append("state=$state,")
        append("suppressed=$suppressed,")
        append("suppressedDate=$suppressedDate,")
        append("suppressedUntil=$suppressedUntil")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active.hashCode()
        result = 31 * result + (anomalyDetectorArn.hashCode())
        result = 31 * result + (anomalyId.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (firstSeen.hashCode())
        result = 31 * result + (histogram.hashCode())
        result = 31 * result + (isPatternLevelSuppression?.hashCode() ?: 0)
        result = 31 * result + (lastSeen.hashCode())
        result = 31 * result + (logGroupArnList.hashCode())
        result = 31 * result + (logSamples.hashCode())
        result = 31 * result + (patternId.hashCode())
        result = 31 * result + (patternRegex?.hashCode() ?: 0)
        result = 31 * result + (patternString.hashCode())
        result = 31 * result + (patternTokens.hashCode())
        result = 31 * result + (priority?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        result = 31 * result + (suppressed?.hashCode() ?: 0)
        result = 31 * result + (suppressedDate.hashCode())
        result = 31 * result + (suppressedUntil.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Anomaly

        if (active != other.active) return false
        if (anomalyDetectorArn != other.anomalyDetectorArn) return false
        if (anomalyId != other.anomalyId) return false
        if (description != other.description) return false
        if (firstSeen != other.firstSeen) return false
        if (histogram != other.histogram) return false
        if (isPatternLevelSuppression != other.isPatternLevelSuppression) return false
        if (lastSeen != other.lastSeen) return false
        if (logGroupArnList != other.logGroupArnList) return false
        if (logSamples != other.logSamples) return false
        if (patternId != other.patternId) return false
        if (patternRegex != other.patternRegex) return false
        if (patternString != other.patternString) return false
        if (patternTokens != other.patternTokens) return false
        if (priority != other.priority) return false
        if (state != other.state) return false
        if (suppressed != other.suppressed) return false
        if (suppressedDate != other.suppressedDate) return false
        if (suppressedUntil != other.suppressedUntil) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.Anomaly = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether this anomaly is still ongoing.
         */
        public var active: kotlin.Boolean? = null
        /**
         * The ARN of the anomaly detector that identified this anomaly.
         */
        public var anomalyDetectorArn: kotlin.String? = null
        /**
         * The unique ID that CloudWatch Logs assigned to this anomaly.
         */
        public var anomalyId: kotlin.String? = null
        /**
         * A human-readable description of the anomaly. This description is generated by CloudWatch Logs.
         */
        public var description: kotlin.String? = null
        /**
         * The date and time when the anomaly detector first saw this anomaly. It is specified as epoch time, which is the number of seconds since `January 1, 1970, 00:00:00 UTC`.
         */
        public var firstSeen: kotlin.Long = 0L
        /**
         * A map showing times when the anomaly detector ran, and the number of occurrences of this anomaly that were detected at each of those runs. The times are specified in epoch time, which is the number of seconds since `January 1, 1970, 00:00:00 UTC`.
         */
        public var histogram: Map<String, Long>? = null
        /**
         * If this anomaly is suppressed, this field is `true` if the suppression is because the pattern is suppressed. If `false`, then only this particular anomaly is suppressed.
         */
        public var isPatternLevelSuppression: kotlin.Boolean? = null
        /**
         * The date and time when the anomaly detector most recently saw this anomaly. It is specified as epoch time, which is the number of seconds since `January 1, 1970, 00:00:00 UTC`.
         */
        public var lastSeen: kotlin.Long = 0L
        /**
         * An array of ARNS of the log groups that contained log events considered to be part of this anomaly.
         */
        public var logGroupArnList: List<String>? = null
        /**
         * An array of sample log event messages that are considered to be part of this anomaly.
         */
        public var logSamples: List<LogEvent>? = null
        /**
         * The ID of the pattern used to help identify this anomaly.
         */
        public var patternId: kotlin.String? = null
        /**
         * The pattern used to help identify this anomaly, in regular expression format.
         */
        public var patternRegex: kotlin.String? = null
        /**
         * The pattern used to help identify this anomaly, in string format.
         */
        public var patternString: kotlin.String? = null
        /**
         * An array of structures where each structure contains information about one token that makes up the pattern.
         */
        public var patternTokens: List<PatternToken>? = null
        /**
         * The priority level of this anomaly, as determined by CloudWatch Logs. Priority is computed based on log severity labels such as `FATAL` and `ERROR` and the amount of deviation from the baseline. Possible values are `HIGH`, `MEDIUM`, and `LOW`.
         */
        public var priority: kotlin.String? = null
        /**
         * Indicates the current state of this anomaly. If it is still being treated as an anomaly, the value is `Active`. If you have suppressed this anomaly by using the [UpdateAnomaly](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateAnomaly.html) operation, the value is `Suppressed`. If this behavior is now considered to be normal, the value is `Baseline`.
         */
        public var state: aws.sdk.kotlin.services.cloudwatchlogs.model.State? = null
        /**
         * Indicates whether this anomaly is currently suppressed. To suppress an anomaly, use [UpdateAnomaly](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateAnomaly.html).
         */
        public var suppressed: kotlin.Boolean? = null
        /**
         * If the anomaly is suppressed, this indicates when it was suppressed.
         */
        public var suppressedDate: kotlin.Long = 0L
        /**
         * If the anomaly is suppressed, this indicates when the suppression will end. If this value is `0`, the anomaly was suppressed with no expiration, with the `INFINITE` value.
         */
        public var suppressedUntil: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.Anomaly) : this() {
            this.active = x.active
            this.anomalyDetectorArn = x.anomalyDetectorArn
            this.anomalyId = x.anomalyId
            this.description = x.description
            this.firstSeen = x.firstSeen
            this.histogram = x.histogram
            this.isPatternLevelSuppression = x.isPatternLevelSuppression
            this.lastSeen = x.lastSeen
            this.logGroupArnList = x.logGroupArnList
            this.logSamples = x.logSamples
            this.patternId = x.patternId
            this.patternRegex = x.patternRegex
            this.patternString = x.patternString
            this.patternTokens = x.patternTokens
            this.priority = x.priority
            this.state = x.state
            this.suppressed = x.suppressed
            this.suppressedDate = x.suppressedDate
            this.suppressedUntil = x.suppressedUntil
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.Anomaly = Anomaly(this)

        internal fun correctErrors(): Builder {
            if (active == null) active = false
            if (anomalyDetectorArn == null) anomalyDetectorArn = ""
            if (anomalyId == null) anomalyId = ""
            if (description == null) description = ""
            if (histogram == null) histogram = emptyMap()
            if (logGroupArnList == null) logGroupArnList = emptyList()
            if (logSamples == null) logSamples = emptyList()
            if (patternId == null) patternId = ""
            if (patternString == null) patternString = ""
            if (patternTokens == null) patternTokens = emptyList()
            if (state == null) state = State.SdkUnknown("no value provided")
            return this
        }
    }
}
