// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This object defines one key that will be added with the [ addKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKey) processor.
 */
public class AddKeyEntry private constructor(builder: Builder) {
    /**
     * The key of the new entry to be added to the log event
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * Specifies whether to overwrite the value if the key already exists in the log event. If you omit this, the default is `false`.
     */
    public val overwriteIfExists: kotlin.Boolean = builder.overwriteIfExists
    /**
     * The value of the new entry to be added to the log event
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.AddKeyEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddKeyEntry(")
        append("key=$key,")
        append("overwriteIfExists=$overwriteIfExists,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (overwriteIfExists.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddKeyEntry

        if (key != other.key) return false
        if (overwriteIfExists != other.overwriteIfExists) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.AddKeyEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The key of the new entry to be added to the log event
         */
        public var key: kotlin.String? = null
        /**
         * Specifies whether to overwrite the value if the key already exists in the log event. If you omit this, the default is `false`.
         */
        public var overwriteIfExists: kotlin.Boolean = false
        /**
         * The value of the new entry to be added to the log event
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.AddKeyEntry) : this() {
            this.key = x.key
            this.overwriteIfExists = x.overwriteIfExists
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.AddKeyEntry = AddKeyEntry(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (value == null) value = ""
            return this
        }
    }
}
