// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains information about one CloudWatch Logs account policy.
 */
public class AccountPolicy private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID that the policy applies to.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The date and time that this policy was most recently updated.
     */
    public val lastUpdatedTime: kotlin.Long? = builder.lastUpdatedTime
    /**
     * The policy document for this account policy.
     *
     * The JSON specified in `policyDocument` can be up to 30,720 characters.
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * The name of the account policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * The type of policy for this account policy.
     */
    public val policyType: aws.sdk.kotlin.services.cloudwatchlogs.model.PolicyType? = builder.policyType
    /**
     * The scope of the account policy.
     */
    public val scope: aws.sdk.kotlin.services.cloudwatchlogs.model.Scope? = builder.scope
    /**
     * The log group selection criteria that is used for this policy.
     */
    public val selectionCriteria: kotlin.String? = builder.selectionCriteria

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.AccountPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountPolicy(")
        append("accountId=$accountId,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName,")
        append("policyType=$policyType,")
        append("scope=$scope,")
        append("selectionCriteria=$selectionCriteria")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (selectionCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountPolicy

        if (accountId != other.accountId) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false
        if (policyType != other.policyType) return false
        if (scope != other.scope) return false
        if (selectionCriteria != other.selectionCriteria) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.AccountPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID that the policy applies to.
         */
        public var accountId: kotlin.String? = null
        /**
         * The date and time that this policy was most recently updated.
         */
        public var lastUpdatedTime: kotlin.Long? = null
        /**
         * The policy document for this account policy.
         *
         * The JSON specified in `policyDocument` can be up to 30,720 characters.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The name of the account policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * The type of policy for this account policy.
         */
        public var policyType: aws.sdk.kotlin.services.cloudwatchlogs.model.PolicyType? = null
        /**
         * The scope of the account policy.
         */
        public var scope: aws.sdk.kotlin.services.cloudwatchlogs.model.Scope? = null
        /**
         * The log group selection criteria that is used for this policy.
         */
        public var selectionCriteria: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.AccountPolicy) : this() {
            this.accountId = x.accountId
            this.lastUpdatedTime = x.lastUpdatedTime
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
            this.policyType = x.policyType
            this.scope = x.scope
            this.selectionCriteria = x.selectionCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.AccountPolicy = AccountPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
