// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.serde

import aws.sdk.kotlin.services.cloudwatchlogs.model.Entity
import aws.sdk.kotlin.services.cloudwatchlogs.model.InputLogEvent
import aws.sdk.kotlin.services.cloudwatchlogs.model.PutLogEventsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutLogEventsOperationSerializer: HttpSerializer.NonStreaming<PutLogEventsRequest> {
    override fun serialize(context: ExecutionContext, input: PutLogEventsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializePutLogEventsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializePutLogEventsOperationBody(context: ExecutionContext, input: PutLogEventsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("entity"))
    val LOGEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("logEvents"))
    val LOGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logGroupName"))
    val LOGSTREAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logStreamName"))
    val SEQUENCETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sequenceToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITY_DESCRIPTOR)
        field(LOGEVENTS_DESCRIPTOR)
        field(LOGGROUPNAME_DESCRIPTOR)
        field(LOGSTREAMNAME_DESCRIPTOR)
        field(SEQUENCETOKEN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.entity?.let { field(ENTITY_DESCRIPTOR, it, ::serializeEntityDocument) }
        if (input.logEvents != null) {
            listField(LOGEVENTS_DESCRIPTOR) {
                for (el0 in input.logEvents) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputLogEventDocument))
                }
            }
        }
        input.logGroupName?.let { field(LOGGROUPNAME_DESCRIPTOR, it) }
        input.logStreamName?.let { field(LOGSTREAMNAME_DESCRIPTOR, it) }
        input.sequenceToken?.let { field(SEQUENCETOKEN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
