// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.serde

import aws.sdk.kotlin.services.cloudwatchlogs.model.AnomalyDetectorStatus
import aws.sdk.kotlin.services.cloudwatchlogs.model.CloudWatchLogsException
import aws.sdk.kotlin.services.cloudwatchlogs.model.EvaluationFrequency
import aws.sdk.kotlin.services.cloudwatchlogs.model.GetLogAnomalyDetectorResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetLogAnomalyDetectorOperationDeserializer: HttpDeserializer.NonStreaming<GetLogAnomalyDetectorResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetLogAnomalyDetectorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetLogAnomalyDetectorError(context, call, payload)
        }
        val builder = GetLogAnomalyDetectorResponse.Builder()

        if (payload != null) {
            deserializeGetLogAnomalyDetectorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetLogAnomalyDetectorError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudWatchLogsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationAbortedException" -> OperationAbortedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudWatchLogsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLogAnomalyDetectorOperationBody(builder: GetLogAnomalyDetectorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALYDETECTORSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("anomalyDetectorStatus"))
    val ANOMALYVISIBILITYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("anomalyVisibilityTime"))
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("creationTimeStamp"))
    val DETECTORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("detectorName"))
    val EVALUATIONFREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("evaluationFrequency"))
    val FILTERPATTERN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("filterPattern"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val LASTMODIFIEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("lastModifiedTimeStamp"))
    val LOGGROUPARNLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("logGroupArnList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALYDETECTORSTATUS_DESCRIPTOR)
        field(ANOMALYVISIBILITYTIME_DESCRIPTOR)
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(DETECTORNAME_DESCRIPTOR)
        field(EVALUATIONFREQUENCY_DESCRIPTOR)
        field(FILTERPATTERN_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LASTMODIFIEDTIMESTAMP_DESCRIPTOR)
        field(LOGGROUPARNLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALYDETECTORSTATUS_DESCRIPTOR.index -> builder.anomalyDetectorStatus = deserializeString().let { AnomalyDetectorStatus.fromValue(it) }
                ANOMALYVISIBILITYTIME_DESCRIPTOR.index -> builder.anomalyVisibilityTime = deserializeLong()
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimeStamp = deserializeLong()
                DETECTORNAME_DESCRIPTOR.index -> builder.detectorName = deserializeString()
                EVALUATIONFREQUENCY_DESCRIPTOR.index -> builder.evaluationFrequency = deserializeString().let { EvaluationFrequency.fromValue(it) }
                FILTERPATTERN_DESCRIPTOR.index -> builder.filterPattern = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LASTMODIFIEDTIMESTAMP_DESCRIPTOR.index -> builder.lastModifiedTimeStamp = deserializeLong()
                LOGGROUPARNLIST_DESCRIPTOR.index -> builder.logGroupArnList =
                    deserializer.deserializeList(LOGGROUPARNLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
