// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Indicates how to transform ingested log events to metric data in a CloudWatch metric.
 */
public class MetricTransformation private constructor(builder: Builder) {
    /**
     * (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
     */
    public val defaultValue: kotlin.Double? = builder.defaultValue
    /**
     * The fields to use as dimensions for the metric. One metric filter can include as many as three dimensions.
     *
     * Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as `IPAddress` or `requestID` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric.
     *
     * CloudWatch Logs disables a metric filter if it generates 1000 different name/value pairs for your specified dimensions within a certain amount of time. This helps to prevent accidental high charges.
     *
     * You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [ Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
     */
    public val dimensions: Map<String, String>? = builder.dimensions
    /**
     * The name of the CloudWatch metric.
     */
    public val metricName: kotlin.String = requireNotNull(builder.metricName) { "A non-null value must be provided for metricName" }
    /**
     * A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics that are similar. For more information, see [Namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace).
     */
    public val metricNamespace: kotlin.String = requireNotNull(builder.metricNamespace) { "A non-null value must be provided for metricNamespace" }
    /**
     * The value to publish to the CloudWatch metric when a filter pattern matches a log event.
     */
    public val metricValue: kotlin.String = requireNotNull(builder.metricValue) { "A non-null value must be provided for metricValue" }
    /**
     * The unit to assign to the metric. If you omit this, the unit is set as `None`.
     */
    public val unit: aws.sdk.kotlin.services.cloudwatchlogs.model.StandardUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.MetricTransformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricTransformation(")
        append("defaultValue=$defaultValue,")
        append("dimensions=$dimensions,")
        append("metricName=$metricName,")
        append("metricNamespace=$metricNamespace,")
        append("metricValue=$metricValue,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultValue?.hashCode() ?: 0
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (metricName.hashCode())
        result = 31 * result + (metricNamespace.hashCode())
        result = 31 * result + (metricValue.hashCode())
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricTransformation

        if (!(defaultValue?.equals(other.defaultValue) ?: (other.defaultValue == null))) return false
        if (dimensions != other.dimensions) return false
        if (metricName != other.metricName) return false
        if (metricNamespace != other.metricNamespace) return false
        if (metricValue != other.metricValue) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.MetricTransformation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
         */
        public var defaultValue: kotlin.Double? = null
        /**
         * The fields to use as dimensions for the metric. One metric filter can include as many as three dimensions.
         *
         * Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as `IPAddress` or `requestID` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric.
         *
         * CloudWatch Logs disables a metric filter if it generates 1000 different name/value pairs for your specified dimensions within a certain amount of time. This helps to prevent accidental high charges.
         *
         * You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [ Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
         */
        public var dimensions: Map<String, String>? = null
        /**
         * The name of the CloudWatch metric.
         */
        public var metricName: kotlin.String? = null
        /**
         * A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics that are similar. For more information, see [Namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace).
         */
        public var metricNamespace: kotlin.String? = null
        /**
         * The value to publish to the CloudWatch metric when a filter pattern matches a log event.
         */
        public var metricValue: kotlin.String? = null
        /**
         * The unit to assign to the metric. If you omit this, the unit is set as `None`.
         */
        public var unit: aws.sdk.kotlin.services.cloudwatchlogs.model.StandardUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.MetricTransformation) : this() {
            this.defaultValue = x.defaultValue
            this.dimensions = x.dimensions
            this.metricName = x.metricName
            this.metricNamespace = x.metricNamespace
            this.metricValue = x.metricValue
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.MetricTransformation = MetricTransformation(this)

        internal fun correctErrors(): Builder {
            if (metricName == null) metricName = ""
            if (metricNamespace == null) metricNamespace = ""
            if (metricValue == null) metricValue = ""
            return this
        }
    }
}
