// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeLogStreamsRequest private constructor(builder: Builder) {
    /**
     * If the value is true, results are returned in descending order. If the value is to false, results are returned in ascending order. The default value is false.
     */
    public val descending: kotlin.Boolean? = builder.descending
    /**
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * Specify either the name or ARN of the log group to view. If the log group is in a source account and you are using a monitoring account, you must use the log group ARN.
     *
     *  You must include either `logGroupIdentifier` or `logGroupName`, but not both.
     */
    public val logGroupIdentifier: kotlin.String? = builder.logGroupIdentifier
    /**
     * The name of the log group.
     *
     *  You must include either `logGroupIdentifier` or `logGroupName`, but not both.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The prefix to match.
     *
     * If `orderBy` is `LastEventTime`, you cannot specify this parameter.
     */
    public val logStreamNamePrefix: kotlin.String? = builder.logStreamNamePrefix
    /**
     * The token for the next set of items to return. (You received this token from a previous call.)
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * If the value is `LogStreamName`, the results are ordered by log stream name. If the value is `LastEventTime`, the results are ordered by the event time. The default value is `LogStreamName`.
     *
     * If you order the results by event time, you cannot specify the `logStreamNamePrefix` parameter.
     *
     * `lastEventTimestamp` represents the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. `lastEventTimestamp` updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.
     */
    public val orderBy: aws.sdk.kotlin.services.cloudwatchlogs.model.OrderBy? = builder.orderBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogStreamsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLogStreamsRequest(")
        append("descending=$descending,")
        append("limit=$limit,")
        append("logGroupIdentifier=$logGroupIdentifier,")
        append("logGroupName=$logGroupName,")
        append("logStreamNamePrefix=$logStreamNamePrefix,")
        append("nextToken=$nextToken,")
        append("orderBy=$orderBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = descending?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (logGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (logStreamNamePrefix?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeLogStreamsRequest

        if (descending != other.descending) return false
        if (limit != other.limit) return false
        if (logGroupIdentifier != other.logGroupIdentifier) return false
        if (logGroupName != other.logGroupName) return false
        if (logStreamNamePrefix != other.logStreamNamePrefix) return false
        if (nextToken != other.nextToken) return false
        if (orderBy != other.orderBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogStreamsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If the value is true, results are returned in descending order. If the value is to false, results are returned in ascending order. The default value is false.
         */
        public var descending: kotlin.Boolean? = null
        /**
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         */
        public var limit: kotlin.Int? = null
        /**
         * Specify either the name or ARN of the log group to view. If the log group is in a source account and you are using a monitoring account, you must use the log group ARN.
         *
         *  You must include either `logGroupIdentifier` or `logGroupName`, but not both.
         */
        public var logGroupIdentifier: kotlin.String? = null
        /**
         * The name of the log group.
         *
         *  You must include either `logGroupIdentifier` or `logGroupName`, but not both.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The prefix to match.
         *
         * If `orderBy` is `LastEventTime`, you cannot specify this parameter.
         */
        public var logStreamNamePrefix: kotlin.String? = null
        /**
         * The token for the next set of items to return. (You received this token from a previous call.)
         */
        public var nextToken: kotlin.String? = null
        /**
         * If the value is `LogStreamName`, the results are ordered by log stream name. If the value is `LastEventTime`, the results are ordered by the event time. The default value is `LogStreamName`.
         *
         * If you order the results by event time, you cannot specify the `logStreamNamePrefix` parameter.
         *
         * `lastEventTimestamp` represents the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. `lastEventTimestamp` updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.
         */
        public var orderBy: aws.sdk.kotlin.services.cloudwatchlogs.model.OrderBy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogStreamsRequest) : this() {
            this.descending = x.descending
            this.limit = x.limit
            this.logGroupIdentifier = x.logGroupIdentifier
            this.logGroupName = x.logGroupName
            this.logStreamNamePrefix = x.logStreamNamePrefix
            this.nextToken = x.nextToken
            this.orderBy = x.orderBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogStreamsRequest = DescribeLogStreamsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
