// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.serde

import aws.sdk.kotlin.services.cloudwatchlogs.model.CloudWatchLogsException
import aws.sdk.kotlin.services.cloudwatchlogs.model.StartLiveTailResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.StartLiveTailResponseStream
import aws.smithy.kotlin.runtime.ClientException
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.MessageType
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.decodeFrames
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.type
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.util.mergeSequential
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flowOf
import kotlinx.coroutines.flow.map
import kotlinx.coroutines.flow.single
import kotlinx.coroutines.flow.take


internal class StartLiveTailOperationDeserializer: HttpDeserializer.Streaming<StartLiveTailResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): StartLiveTailResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            val payload = response.body.readAll()
            throwStartLiveTailError(context, call, payload)
        }
        val builder = StartLiveTailResponse.Builder()

        deserializeStartLiveTailOperationBody(builder, call)
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartLiveTailError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudWatchLogsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudWatchLogsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeStartLiveTailOperationBody(builder: StartLiveTailResponse.Builder, call: HttpCall) {
    val chan = call.response.body.toSdkByteReadChannel(call) ?: return
    val frames = decodeFrames(chan)
    val firstMessage = frames.take(1).single()
    val firstMessageType = firstMessage.type()
    val events = if (firstMessageType is MessageType.Event && firstMessageType.shapeType == "initial-response") {
        val initialResponse = deserializeStartLiveTailResponsePayloadkKgqd0lv(firstMessage.payload)
        builder.apply {
        }
        frames
    } else {
        mergeSequential(flowOf(firstMessage), frames)
    }
        .map { message ->
            when (val mt = message.type()) {
                is MessageType.Event -> when (mt.shapeType) {
                    "sessionStart" -> {
                        val e = deserializeLiveTailSessionStartPayload(message.payload)
                        StartLiveTailResponseStream.SessionStart(e)
                    }
                    "sessionUpdate" -> {
                        val e = deserializeLiveTailSessionUpdatePayload(message.payload)
                        StartLiveTailResponseStream.SessionUpdate(e)
                    }
                    else -> StartLiveTailResponseStream.SdkUnknown
                }
                is MessageType.Exception -> when (mt.shapeType) {
                    "SessionTimeoutException" -> {
                        val err = deserializeSessionTimeoutExceptionPayload(message.payload)
                        throw err
                    }
                    "SessionStreamingException" -> {
                        val err = deserializeSessionStreamingExceptionPayload(message.payload)
                        throw err
                    }
                    else -> throw CloudWatchLogsException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw CloudWatchLogsException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }

    builder.responseStream = events
}
