// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.paginators

import aws.sdk.kotlin.services.cloudwatchlogs.CloudWatchLogsClient
import aws.sdk.kotlin.services.cloudwatchlogs.model.Anomaly
import aws.sdk.kotlin.services.cloudwatchlogs.model.AnomalyDetector
import aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplate
import aws.sdk.kotlin.services.cloudwatchlogs.model.Delivery
import aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestination
import aws.sdk.kotlin.services.cloudwatchlogs.model.DeliverySource
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeDeliveriesRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeDeliveriesResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeDestinationsRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeDestinationsResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogGroupsRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogGroupsResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogStreamsRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogStreamsResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeMetricFiltersRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeMetricFiltersResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.Destination
import aws.sdk.kotlin.services.cloudwatchlogs.model.FilterLogEventsRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.FilterLogEventsResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.GetLogEventsRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.GetLogEventsResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.ListAnomaliesRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.ListAnomaliesResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest
import aws.sdk.kotlin.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroup
import aws.sdk.kotlin.services.cloudwatchlogs.model.LogStream
import aws.sdk.kotlin.services.cloudwatchlogs.model.MetricFilter
import aws.sdk.kotlin.services.cloudwatchlogs.model.OutputLogEvent
import aws.sdk.kotlin.services.cloudwatchlogs.model.SubscriptionFilter
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeConfigurationTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeConfigurationTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeConfigurationTemplatesResponse]
 */
public fun CloudWatchLogsClient.describeConfigurationTemplatesPaginated(initialRequest: DescribeConfigurationTemplatesRequest = DescribeConfigurationTemplatesRequest { }): Flow<DescribeConfigurationTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeConfigurationTemplatesPaginated.describeConfigurationTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeConfigurationTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeConfigurationTemplatesResponse]
 */
public fun CloudWatchLogsClient.describeConfigurationTemplatesPaginated(block: DescribeConfigurationTemplatesRequest.Builder.() -> Unit): Flow<DescribeConfigurationTemplatesResponse> =
    describeConfigurationTemplatesPaginated(DescribeConfigurationTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeConfigurationTemplatesPaginated]
 * to access the nested member [ConfigurationTemplate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConfigurationTemplate]
 */
@JvmName("describeConfigurationTemplatesResponseConfigurationTemplate")
public fun Flow<DescribeConfigurationTemplatesResponse>.configurationTemplates(): Flow<ConfigurationTemplate> =
    transform() { response ->
        response.configurationTemplates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDeliveriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDeliveriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDeliveriesResponse]
 */
public fun CloudWatchLogsClient.describeDeliveriesPaginated(initialRequest: DescribeDeliveriesRequest = DescribeDeliveriesRequest { }): Flow<DescribeDeliveriesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDeliveriesPaginated.describeDeliveries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDeliveriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDeliveriesResponse]
 */
public fun CloudWatchLogsClient.describeDeliveriesPaginated(block: DescribeDeliveriesRequest.Builder.() -> Unit): Flow<DescribeDeliveriesResponse> =
    describeDeliveriesPaginated(DescribeDeliveriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDeliveriesPaginated]
 * to access the nested member [Delivery]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Delivery]
 */
@JvmName("describeDeliveriesResponseDelivery")
public fun Flow<DescribeDeliveriesResponse>.deliveries(): Flow<Delivery> =
    transform() { response ->
        response.deliveries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDeliveryDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDeliveryDestinationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDeliveryDestinationsResponse]
 */
public fun CloudWatchLogsClient.describeDeliveryDestinationsPaginated(initialRequest: DescribeDeliveryDestinationsRequest = DescribeDeliveryDestinationsRequest { }): Flow<DescribeDeliveryDestinationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDeliveryDestinationsPaginated.describeDeliveryDestinations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDeliveryDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDeliveryDestinationsResponse]
 */
public fun CloudWatchLogsClient.describeDeliveryDestinationsPaginated(block: DescribeDeliveryDestinationsRequest.Builder.() -> Unit): Flow<DescribeDeliveryDestinationsResponse> =
    describeDeliveryDestinationsPaginated(DescribeDeliveryDestinationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDeliveryDestinationsPaginated]
 * to access the nested member [DeliveryDestination]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeliveryDestination]
 */
@JvmName("describeDeliveryDestinationsResponseDeliveryDestination")
public fun Flow<DescribeDeliveryDestinationsResponse>.deliveryDestinations(): Flow<DeliveryDestination> =
    transform() { response ->
        response.deliveryDestinations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDeliverySourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDeliverySourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDeliverySourcesResponse]
 */
public fun CloudWatchLogsClient.describeDeliverySourcesPaginated(initialRequest: DescribeDeliverySourcesRequest = DescribeDeliverySourcesRequest { }): Flow<DescribeDeliverySourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDeliverySourcesPaginated.describeDeliverySources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDeliverySourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDeliverySourcesResponse]
 */
public fun CloudWatchLogsClient.describeDeliverySourcesPaginated(block: DescribeDeliverySourcesRequest.Builder.() -> Unit): Flow<DescribeDeliverySourcesResponse> =
    describeDeliverySourcesPaginated(DescribeDeliverySourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDeliverySourcesPaginated]
 * to access the nested member [DeliverySource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeliverySource]
 */
@JvmName("describeDeliverySourcesResponseDeliverySource")
public fun Flow<DescribeDeliverySourcesResponse>.deliverySources(): Flow<DeliverySource> =
    transform() { response ->
        response.deliverySources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDestinationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDestinationsResponse]
 */
public fun CloudWatchLogsClient.describeDestinationsPaginated(initialRequest: DescribeDestinationsRequest = DescribeDestinationsRequest { }): Flow<DescribeDestinationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDestinationsPaginated.describeDestinations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDestinationsResponse]
 */
public fun CloudWatchLogsClient.describeDestinationsPaginated(block: DescribeDestinationsRequest.Builder.() -> Unit): Flow<DescribeDestinationsResponse> =
    describeDestinationsPaginated(DescribeDestinationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDestinationsPaginated]
 * to access the nested member [Destination]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Destination]
 */
@JvmName("describeDestinationsResponseDestination")
public fun Flow<DescribeDestinationsResponse>.destinations(): Flow<Destination> =
    transform() { response ->
        response.destinations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeLogGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLogGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLogGroupsResponse]
 */
public fun CloudWatchLogsClient.describeLogGroupsPaginated(initialRequest: DescribeLogGroupsRequest = DescribeLogGroupsRequest { }): Flow<DescribeLogGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeLogGroupsPaginated.describeLogGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLogGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLogGroupsResponse]
 */
public fun CloudWatchLogsClient.describeLogGroupsPaginated(block: DescribeLogGroupsRequest.Builder.() -> Unit): Flow<DescribeLogGroupsResponse> =
    describeLogGroupsPaginated(DescribeLogGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeLogGroupsPaginated]
 * to access the nested member [LogGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LogGroup]
 */
@JvmName("describeLogGroupsResponseLogGroup")
public fun Flow<DescribeLogGroupsResponse>.logGroups(): Flow<LogGroup> =
    transform() { response ->
        response.logGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeLogStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLogStreamsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLogStreamsResponse]
 */
public fun CloudWatchLogsClient.describeLogStreamsPaginated(initialRequest: DescribeLogStreamsRequest = DescribeLogStreamsRequest { }): Flow<DescribeLogStreamsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeLogStreamsPaginated.describeLogStreams(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLogStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLogStreamsResponse]
 */
public fun CloudWatchLogsClient.describeLogStreamsPaginated(block: DescribeLogStreamsRequest.Builder.() -> Unit): Flow<DescribeLogStreamsResponse> =
    describeLogStreamsPaginated(DescribeLogStreamsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeLogStreamsPaginated]
 * to access the nested member [LogStream]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LogStream]
 */
@JvmName("describeLogStreamsResponseLogStream")
public fun Flow<DescribeLogStreamsResponse>.logStreams(): Flow<LogStream> =
    transform() { response ->
        response.logStreams?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeMetricFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeMetricFiltersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMetricFiltersResponse]
 */
public fun CloudWatchLogsClient.describeMetricFiltersPaginated(initialRequest: DescribeMetricFiltersRequest = DescribeMetricFiltersRequest { }): Flow<DescribeMetricFiltersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeMetricFiltersPaginated.describeMetricFilters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeMetricFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMetricFiltersResponse]
 */
public fun CloudWatchLogsClient.describeMetricFiltersPaginated(block: DescribeMetricFiltersRequest.Builder.() -> Unit): Flow<DescribeMetricFiltersResponse> =
    describeMetricFiltersPaginated(DescribeMetricFiltersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeMetricFiltersPaginated]
 * to access the nested member [MetricFilter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MetricFilter]
 */
@JvmName("describeMetricFiltersResponseMetricFilter")
public fun Flow<DescribeMetricFiltersResponse>.metricFilters(): Flow<MetricFilter> =
    transform() { response ->
        response.metricFilters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSubscriptionFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSubscriptionFiltersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSubscriptionFiltersResponse]
 */
public fun CloudWatchLogsClient.describeSubscriptionFiltersPaginated(initialRequest: DescribeSubscriptionFiltersRequest): Flow<DescribeSubscriptionFiltersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeSubscriptionFiltersPaginated.describeSubscriptionFilters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSubscriptionFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSubscriptionFiltersResponse]
 */
public fun CloudWatchLogsClient.describeSubscriptionFiltersPaginated(block: DescribeSubscriptionFiltersRequest.Builder.() -> Unit): Flow<DescribeSubscriptionFiltersResponse> =
    describeSubscriptionFiltersPaginated(DescribeSubscriptionFiltersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSubscriptionFiltersPaginated]
 * to access the nested member [SubscriptionFilter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SubscriptionFilter]
 */
@JvmName("describeSubscriptionFiltersResponseSubscriptionFilter")
public fun Flow<DescribeSubscriptionFiltersResponse>.subscriptionFilters(): Flow<SubscriptionFilter> =
    transform() { response ->
        response.subscriptionFilters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [FilterLogEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [FilterLogEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FilterLogEventsResponse]
 */
public fun CloudWatchLogsClient.filterLogEventsPaginated(initialRequest: FilterLogEventsRequest = FilterLogEventsRequest { }): Flow<FilterLogEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@filterLogEventsPaginated.filterLogEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [FilterLogEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FilterLogEventsResponse]
 */
public fun CloudWatchLogsClient.filterLogEventsPaginated(block: FilterLogEventsRequest.Builder.() -> Unit): Flow<FilterLogEventsResponse> =
    filterLogEventsPaginated(FilterLogEventsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetLogEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetLogEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLogEventsResponse]
 */
public fun CloudWatchLogsClient.getLogEventsPaginated(initialRequest: GetLogEventsRequest): Flow<GetLogEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getLogEventsPaginated.getLogEvents(req)
            cursor = result.nextForwardToken
            hasNextPage = cursor != null && cursor != req.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetLogEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLogEventsResponse]
 */
public fun CloudWatchLogsClient.getLogEventsPaginated(block: GetLogEventsRequest.Builder.() -> Unit): Flow<GetLogEventsResponse> =
    getLogEventsPaginated(GetLogEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getLogEventsPaginated]
 * to access the nested member [OutputLogEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OutputLogEvent]
 */
@JvmName("getLogEventsResponseOutputLogEvent")
public fun Flow<GetLogEventsResponse>.events(): Flow<OutputLogEvent> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAnomaliesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnomaliesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomaliesResponse]
 */
public fun CloudWatchLogsClient.listAnomaliesPaginated(initialRequest: ListAnomaliesRequest = ListAnomaliesRequest { }): Flow<ListAnomaliesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnomaliesPaginated.listAnomalies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAnomaliesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomaliesResponse]
 */
public fun CloudWatchLogsClient.listAnomaliesPaginated(block: ListAnomaliesRequest.Builder.() -> Unit): Flow<ListAnomaliesResponse> =
    listAnomaliesPaginated(ListAnomaliesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAnomaliesPaginated]
 * to access the nested member [Anomaly]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Anomaly]
 */
@JvmName("listAnomaliesResponseAnomaly")
public fun Flow<ListAnomaliesResponse>.anomalies(): Flow<Anomaly> =
    transform() { response ->
        response.anomalies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLogAnomalyDetectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLogAnomalyDetectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLogAnomalyDetectorsResponse]
 */
public fun CloudWatchLogsClient.listLogAnomalyDetectorsPaginated(initialRequest: ListLogAnomalyDetectorsRequest = ListLogAnomalyDetectorsRequest { }): Flow<ListLogAnomalyDetectorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLogAnomalyDetectorsPaginated.listLogAnomalyDetectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLogAnomalyDetectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLogAnomalyDetectorsResponse]
 */
public fun CloudWatchLogsClient.listLogAnomalyDetectorsPaginated(block: ListLogAnomalyDetectorsRequest.Builder.() -> Unit): Flow<ListLogAnomalyDetectorsResponse> =
    listLogAnomalyDetectorsPaginated(ListLogAnomalyDetectorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLogAnomalyDetectorsPaginated]
 * to access the nested member [AnomalyDetector]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AnomalyDetector]
 */
@JvmName("listLogAnomalyDetectorsResponseAnomalyDetector")
public fun Flow<ListLogAnomalyDetectorsResponse>.anomalyDetectors(): Flow<AnomalyDetector> =
    transform() { response ->
        response.anomalyDetectors?.forEach {
            emit(it)
        }
    }
