// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartLiveTailRequest private constructor(builder: Builder) {
    /**
     * An optional pattern to use to filter the results to include only log events that match the pattern. For example, a filter pattern of `error 404` causes only log events that include both `error` and `404` to be included in the Live Tail stream.
     *
     * Regular expression filter patterns are supported.
     *
     * For more information about filter pattern syntax, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
     */
    public val logEventFilterPattern: kotlin.String? = builder.logEventFilterPattern
    /**
     * An array where each item in the array is a log group to include in the Live Tail session.
     *
     * Specify each log group by its ARN.
     *
     * If you specify an ARN, the ARN can't end with an asterisk (*).
     *
     *  You can include up to 10 log groups.
     */
    public val logGroupIdentifiers: List<String>? = builder.logGroupIdentifiers
    /**
     * If you specify this parameter, then only log events in the log streams that have names that start with the prefixes that you specify here are included in the Live Tail session.
     *
     * If you specify this field, you can't also specify the `logStreamNames` field.
     *
     * You can specify this parameter only if you specify only one log group in `logGroupIdentifiers`.
     */
    public val logStreamNamePrefixes: List<String>? = builder.logStreamNamePrefixes
    /**
     * If you specify this parameter, then only log events in the log streams that you specify here are included in the Live Tail session.
     *
     * If you specify this field, you can't also specify the `logStreamNamePrefixes` field.
     *
     * You can specify this parameter only if you specify only one log group in `logGroupIdentifiers`.
     */
    public val logStreamNames: List<String>? = builder.logStreamNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.StartLiveTailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartLiveTailRequest(")
        append("logEventFilterPattern=$logEventFilterPattern,")
        append("logGroupIdentifiers=$logGroupIdentifiers,")
        append("logStreamNamePrefixes=$logStreamNamePrefixes,")
        append("logStreamNames=$logStreamNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logEventFilterPattern?.hashCode() ?: 0
        result = 31 * result + (logGroupIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (logStreamNamePrefixes?.hashCode() ?: 0)
        result = 31 * result + (logStreamNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartLiveTailRequest

        if (logEventFilterPattern != other.logEventFilterPattern) return false
        if (logGroupIdentifiers != other.logGroupIdentifiers) return false
        if (logStreamNamePrefixes != other.logStreamNamePrefixes) return false
        if (logStreamNames != other.logStreamNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.StartLiveTailRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional pattern to use to filter the results to include only log events that match the pattern. For example, a filter pattern of `error 404` causes only log events that include both `error` and `404` to be included in the Live Tail stream.
         *
         * Regular expression filter patterns are supported.
         *
         * For more information about filter pattern syntax, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
         */
        public var logEventFilterPattern: kotlin.String? = null
        /**
         * An array where each item in the array is a log group to include in the Live Tail session.
         *
         * Specify each log group by its ARN.
         *
         * If you specify an ARN, the ARN can't end with an asterisk (*).
         *
         *  You can include up to 10 log groups.
         */
        public var logGroupIdentifiers: List<String>? = null
        /**
         * If you specify this parameter, then only log events in the log streams that have names that start with the prefixes that you specify here are included in the Live Tail session.
         *
         * If you specify this field, you can't also specify the `logStreamNames` field.
         *
         * You can specify this parameter only if you specify only one log group in `logGroupIdentifiers`.
         */
        public var logStreamNamePrefixes: List<String>? = null
        /**
         * If you specify this parameter, then only log events in the log streams that you specify here are included in the Live Tail session.
         *
         * If you specify this field, you can't also specify the `logStreamNamePrefixes` field.
         *
         * You can specify this parameter only if you specify only one log group in `logGroupIdentifiers`.
         */
        public var logStreamNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.StartLiveTailRequest) : this() {
            this.logEventFilterPattern = x.logEventFilterPattern
            this.logGroupIdentifiers = x.logGroupIdentifiers
            this.logStreamNamePrefixes = x.logStreamNamePrefixes
            this.logStreamNames = x.logStreamNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.StartLiveTailRequest = StartLiveTailRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
