// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutDataProtectionPolicyRequest private constructor(builder: Builder) {
    /**
     * Specify either the log group name or log group ARN.
     */
    public val logGroupIdentifier: kotlin.String? = builder.logGroupIdentifier
    /**
     * Specify the data protection policy, in JSON.
     *
     * This policy must include two JSON blocks:
     * + The first block must include both a `DataIdentifer` array and an `Operation` property with an `Audit` action. The `DataIdentifer` array lists the types of sensitive data that you want to mask. For more information about the available options, see [Types of data that you can mask](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html).The `Operation` property with an `Audit` action is required to find the sensitive data terms. This `Audit` action must contain a `FindingsDestination` object. You can optionally use that `FindingsDestination` object to list one or more destinations to send audit findings to. If you specify destinations such as log groups, Firehose streams, and S3 buckets, they must already exist.
     * + The second block must include both a `DataIdentifer` array and an `Operation` property with an `Deidentify` action. The `DataIdentifer` array must exactly match the `DataIdentifer` array in the first block of the policy.The `Operation` property with the `Deidentify` action is what actually masks the data, and it must contain the ` "MaskConfig": {}` object. The ` "MaskConfig": {}` object must be empty.
     *
     * For an example data protection policy, see the **Examples** section on this page.
     *
     * The contents of the two `DataIdentifer` arrays must match exactly.
     *
     * In addition to the two JSON blocks, the `policyDocument` can also include `Name`, `Description`, and `Version` fields. The `Name` is used as a dimension when CloudWatch Logs reports audit findings metrics to CloudWatch.
     *
     * The JSON specified in `policyDocument` can be up to 30,720 characters.
     */
    public val policyDocument: kotlin.String? = builder.policyDocument

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDataProtectionPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutDataProtectionPolicyRequest(")
        append("logGroupIdentifier=$logGroupIdentifier,")
        append("policyDocument=$policyDocument")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logGroupIdentifier?.hashCode() ?: 0
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutDataProtectionPolicyRequest

        if (logGroupIdentifier != other.logGroupIdentifier) return false
        if (policyDocument != other.policyDocument) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDataProtectionPolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify either the log group name or log group ARN.
         */
        public var logGroupIdentifier: kotlin.String? = null
        /**
         * Specify the data protection policy, in JSON.
         *
         * This policy must include two JSON blocks:
         * + The first block must include both a `DataIdentifer` array and an `Operation` property with an `Audit` action. The `DataIdentifer` array lists the types of sensitive data that you want to mask. For more information about the available options, see [Types of data that you can mask](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html).The `Operation` property with an `Audit` action is required to find the sensitive data terms. This `Audit` action must contain a `FindingsDestination` object. You can optionally use that `FindingsDestination` object to list one or more destinations to send audit findings to. If you specify destinations such as log groups, Firehose streams, and S3 buckets, they must already exist.
         * + The second block must include both a `DataIdentifer` array and an `Operation` property with an `Deidentify` action. The `DataIdentifer` array must exactly match the `DataIdentifer` array in the first block of the policy.The `Operation` property with the `Deidentify` action is what actually masks the data, and it must contain the ` "MaskConfig": {}` object. The ` "MaskConfig": {}` object must be empty.
         *
         * For an example data protection policy, see the **Examples** section on this page.
         *
         * The contents of the two `DataIdentifer` arrays must match exactly.
         *
         * In addition to the two JSON blocks, the `policyDocument` can also include `Name`, `Description`, and `Version` fields. The `Name` is used as a dimension when CloudWatch Logs reports audit findings metrics to CloudWatch.
         *
         * The JSON specified in `policyDocument` can be up to 30,720 characters.
         */
        public var policyDocument: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.PutDataProtectionPolicyRequest) : this() {
            this.logGroupIdentifier = x.logGroupIdentifier
            this.policyDocument = x.policyDocument
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDataProtectionPolicyRequest = PutDataProtectionPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
