// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutAccountPolicyRequest private constructor(builder: Builder) {
    /**
     * Specify the policy, in JSON.
     *
     * **Data protection policy**
     *
     * A data protection policy must include two JSON blocks:
     * + The first block must include both a `DataIdentifer` array and an `Operation` property with an `Audit` action. The `DataIdentifer` array lists the types of sensitive data that you want to mask. For more information about the available options, see [Types of data that you can mask](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html).The `Operation` property with an `Audit` action is required to find the sensitive data terms. This `Audit` action must contain a `FindingsDestination` object. You can optionally use that `FindingsDestination` object to list one or more destinations to send audit findings to. If you specify destinations such as log groups, Firehose streams, and S3 buckets, they must already exist.
     * + The second block must include both a `DataIdentifer` array and an `Operation` property with an `Deidentify` action. The `DataIdentifer` array must exactly match the `DataIdentifer` array in the first block of the policy.The `Operation` property with the `Deidentify` action is what actually masks the data, and it must contain the ` "MaskConfig": {}` object. The ` "MaskConfig": {}` object must be empty.
     *
     * For an example data protection policy, see the **Examples** section on this page.
     *
     * The contents of the two `DataIdentifer` arrays must match exactly.
     *
     * In addition to the two JSON blocks, the `policyDocument` can also include `Name`, `Description`, and `Version` fields. The `Name` is different than the operation's `policyName` parameter, and is used as a dimension when CloudWatch Logs reports audit findings metrics to CloudWatch.
     *
     * The JSON specified in `policyDocument` can be up to 30,720 characters long.
     *
     * **Subscription filter policy**
     *
     * A subscription filter policy can include the following attributes in a JSON block:
     * + **DestinationArn** The ARN of the destination to deliver log events to. Supported destinations are:
     *    + An Kinesis Data Streams data stream in the same account as the subscription policy, for same-account delivery.
     *    + An Firehose data stream in the same account as the subscription policy, for same-account delivery.
     *    + A Lambda function in the same account as the subscription policy, for same-account delivery.
     *    + A logical destination in a different account created with [PutDestination](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html), for cross-account delivery. Kinesis Data Streams and Firehose are supported as logical destinations.
     * + **RoleArn** The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.
     * + **FilterPattern** A filter pattern for subscribing to a filtered stream of log events.
     * + **Distribution** The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to `Random` for a more even distribution. This property is only applicable when the destination is an Kinesis Data Streams data stream.
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * A name for the policy. This must be unique within the account.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * The type of policy that you're creating or updating.
     */
    public val policyType: aws.sdk.kotlin.services.cloudwatchlogs.model.PolicyType? = builder.policyType
    /**
     * Currently the only valid value for this parameter is `ALL`, which specifies that the data protection policy applies to all log groups in the account. If you omit this parameter, the default of `ALL` is used.
     */
    public val scope: aws.sdk.kotlin.services.cloudwatchlogs.model.Scope? = builder.scope
    /**
     * Use this parameter to apply the subscription filter policy to a subset of log groups in the account. Currently, the only supported filter is `LogGroupName NOT IN []`. The `selectionCriteria` string can be up to 25KB in length. The length is determined by using its UTF-8 bytes.
     *
     * Using the `selectionCriteria` parameter is useful to help prevent infinite loops. For more information, see [Log recursion prevention](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Subscriptions-recursion-prevention.html).
     *
     * Specifing `selectionCriteria` is valid only when you specify ` SUBSCRIPTION_FILTER_POLICY` for `policyType`.
     */
    public val selectionCriteria: kotlin.String? = builder.selectionCriteria

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.PutAccountPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutAccountPolicyRequest(")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName,")
        append("policyType=$policyType,")
        append("scope=$scope,")
        append("selectionCriteria=$selectionCriteria")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyDocument?.hashCode() ?: 0
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (selectionCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutAccountPolicyRequest

        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false
        if (policyType != other.policyType) return false
        if (scope != other.scope) return false
        if (selectionCriteria != other.selectionCriteria) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.PutAccountPolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify the policy, in JSON.
         *
         * **Data protection policy**
         *
         * A data protection policy must include two JSON blocks:
         * + The first block must include both a `DataIdentifer` array and an `Operation` property with an `Audit` action. The `DataIdentifer` array lists the types of sensitive data that you want to mask. For more information about the available options, see [Types of data that you can mask](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html).The `Operation` property with an `Audit` action is required to find the sensitive data terms. This `Audit` action must contain a `FindingsDestination` object. You can optionally use that `FindingsDestination` object to list one or more destinations to send audit findings to. If you specify destinations such as log groups, Firehose streams, and S3 buckets, they must already exist.
         * + The second block must include both a `DataIdentifer` array and an `Operation` property with an `Deidentify` action. The `DataIdentifer` array must exactly match the `DataIdentifer` array in the first block of the policy.The `Operation` property with the `Deidentify` action is what actually masks the data, and it must contain the ` "MaskConfig": {}` object. The ` "MaskConfig": {}` object must be empty.
         *
         * For an example data protection policy, see the **Examples** section on this page.
         *
         * The contents of the two `DataIdentifer` arrays must match exactly.
         *
         * In addition to the two JSON blocks, the `policyDocument` can also include `Name`, `Description`, and `Version` fields. The `Name` is different than the operation's `policyName` parameter, and is used as a dimension when CloudWatch Logs reports audit findings metrics to CloudWatch.
         *
         * The JSON specified in `policyDocument` can be up to 30,720 characters long.
         *
         * **Subscription filter policy**
         *
         * A subscription filter policy can include the following attributes in a JSON block:
         * + **DestinationArn** The ARN of the destination to deliver log events to. Supported destinations are:
         *    + An Kinesis Data Streams data stream in the same account as the subscription policy, for same-account delivery.
         *    + An Firehose data stream in the same account as the subscription policy, for same-account delivery.
         *    + A Lambda function in the same account as the subscription policy, for same-account delivery.
         *    + A logical destination in a different account created with [PutDestination](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html), for cross-account delivery. Kinesis Data Streams and Firehose are supported as logical destinations.
         * + **RoleArn** The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.
         * + **FilterPattern** A filter pattern for subscribing to a filtered stream of log events.
         * + **Distribution** The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to `Random` for a more even distribution. This property is only applicable when the destination is an Kinesis Data Streams data stream.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * A name for the policy. This must be unique within the account.
         */
        public var policyName: kotlin.String? = null
        /**
         * The type of policy that you're creating or updating.
         */
        public var policyType: aws.sdk.kotlin.services.cloudwatchlogs.model.PolicyType? = null
        /**
         * Currently the only valid value for this parameter is `ALL`, which specifies that the data protection policy applies to all log groups in the account. If you omit this parameter, the default of `ALL` is used.
         */
        public var scope: aws.sdk.kotlin.services.cloudwatchlogs.model.Scope? = null
        /**
         * Use this parameter to apply the subscription filter policy to a subset of log groups in the account. Currently, the only supported filter is `LogGroupName NOT IN []`. The `selectionCriteria` string can be up to 25KB in length. The length is determined by using its UTF-8 bytes.
         *
         * Using the `selectionCriteria` parameter is useful to help prevent infinite loops. For more information, see [Log recursion prevention](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Subscriptions-recursion-prevention.html).
         *
         * Specifing `selectionCriteria` is valid only when you specify ` SUBSCRIPTION_FILTER_POLICY` for `policyType`.
         */
        public var selectionCriteria: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.PutAccountPolicyRequest) : this() {
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
            this.policyType = x.policyType
            this.scope = x.scope
            this.selectionCriteria = x.selectionCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.PutAccountPolicyRequest = PutAccountPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
