// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains information about one pattern token related to an anomaly.
 *
 * For more information about patterns and tokens, see [CreateLogAnomalyDetector](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateLogAnomalyDetector.html).
 */
public class PatternToken private constructor(builder: Builder) {
    /**
     * For a dynamic token, this indicates where in the pattern that this token appears, related to other dynamic tokens. The dynamic token that appears first has a value of `1`, the one that appears second is `2`, and so on.
     */
    public val dynamicTokenPosition: kotlin.Int = builder.dynamicTokenPosition
    /**
     * Contains the values found for a dynamic token, and the number of times each value was found.
     */
    public val enumerations: Map<String, Long>? = builder.enumerations
    /**
     * Specifies whether this is a dynamic token.
     */
    public val isDynamic: kotlin.Boolean? = builder.isDynamic
    /**
     * The string represented by this token. If this is a dynamic token, the value will be `<*>`
     */
    public val tokenString: kotlin.String? = builder.tokenString

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.PatternToken = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatternToken(")
        append("dynamicTokenPosition=$dynamicTokenPosition,")
        append("enumerations=$enumerations,")
        append("isDynamic=$isDynamic,")
        append("tokenString=$tokenString")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dynamicTokenPosition
        result = 31 * result + (enumerations?.hashCode() ?: 0)
        result = 31 * result + (isDynamic?.hashCode() ?: 0)
        result = 31 * result + (tokenString?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatternToken

        if (dynamicTokenPosition != other.dynamicTokenPosition) return false
        if (enumerations != other.enumerations) return false
        if (isDynamic != other.isDynamic) return false
        if (tokenString != other.tokenString) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.PatternToken = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For a dynamic token, this indicates where in the pattern that this token appears, related to other dynamic tokens. The dynamic token that appears first has a value of `1`, the one that appears second is `2`, and so on.
         */
        public var dynamicTokenPosition: kotlin.Int = 0
        /**
         * Contains the values found for a dynamic token, and the number of times each value was found.
         */
        public var enumerations: Map<String, Long>? = null
        /**
         * Specifies whether this is a dynamic token.
         */
        public var isDynamic: kotlin.Boolean? = null
        /**
         * The string represented by this token. If this is a dynamic token, the value will be `<*>`
         */
        public var tokenString: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.PatternToken) : this() {
            this.dynamicTokenPosition = x.dynamicTokenPosition
            this.enumerations = x.enumerations
            this.isDynamic = x.isDynamic
            this.tokenString = x.tokenString
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.PatternToken = PatternToken(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
