// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This object contains information about this Live Tail session, including the log groups included and the log stream filters, if any.
 */
public class LiveTailSessionStart private constructor(builder: Builder) {
    /**
     * An optional pattern to filter the results to include only log events that match the pattern. For example, a filter pattern of `error 404` displays only log events that include both `error` and `404`.
     *
     * For more information about filter pattern syntax, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
     */
    public val logEventFilterPattern: kotlin.String? = builder.logEventFilterPattern
    /**
     * An array of the names and ARNs of the log groups included in this Live Tail session.
     */
    public val logGroupIdentifiers: List<String>? = builder.logGroupIdentifiers
    /**
     * If your StartLiveTail operation request included a `logStreamNamePrefixes` parameter that filtered the session to only include log streams that have names that start with certain prefixes, these prefixes are listed here.
     */
    public val logStreamNamePrefixes: List<String>? = builder.logStreamNamePrefixes
    /**
     * If your StartLiveTail operation request included a `logStreamNames` parameter that filtered the session to only include certain log streams, these streams are listed here.
     */
    public val logStreamNames: List<String>? = builder.logStreamNames
    /**
     * The unique ID generated by CloudWatch Logs to identify this Live Tail session request.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * The unique ID generated by CloudWatch Logs to identify this Live Tail session.
     */
    public val sessionId: kotlin.String? = builder.sessionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.LiveTailSessionStart = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LiveTailSessionStart(")
        append("logEventFilterPattern=$logEventFilterPattern,")
        append("logGroupIdentifiers=$logGroupIdentifiers,")
        append("logStreamNamePrefixes=$logStreamNamePrefixes,")
        append("logStreamNames=$logStreamNames,")
        append("requestId=$requestId,")
        append("sessionId=$sessionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logEventFilterPattern?.hashCode() ?: 0
        result = 31 * result + (logGroupIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (logStreamNamePrefixes?.hashCode() ?: 0)
        result = 31 * result + (logStreamNames?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LiveTailSessionStart

        if (logEventFilterPattern != other.logEventFilterPattern) return false
        if (logGroupIdentifiers != other.logGroupIdentifiers) return false
        if (logStreamNamePrefixes != other.logStreamNamePrefixes) return false
        if (logStreamNames != other.logStreamNames) return false
        if (requestId != other.requestId) return false
        if (sessionId != other.sessionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.LiveTailSessionStart = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional pattern to filter the results to include only log events that match the pattern. For example, a filter pattern of `error 404` displays only log events that include both `error` and `404`.
         *
         * For more information about filter pattern syntax, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
         */
        public var logEventFilterPattern: kotlin.String? = null
        /**
         * An array of the names and ARNs of the log groups included in this Live Tail session.
         */
        public var logGroupIdentifiers: List<String>? = null
        /**
         * If your StartLiveTail operation request included a `logStreamNamePrefixes` parameter that filtered the session to only include log streams that have names that start with certain prefixes, these prefixes are listed here.
         */
        public var logStreamNamePrefixes: List<String>? = null
        /**
         * If your StartLiveTail operation request included a `logStreamNames` parameter that filtered the session to only include certain log streams, these streams are listed here.
         */
        public var logStreamNames: List<String>? = null
        /**
         * The unique ID generated by CloudWatch Logs to identify this Live Tail session request.
         */
        public var requestId: kotlin.String? = null
        /**
         * The unique ID generated by CloudWatch Logs to identify this Live Tail session.
         */
        public var sessionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.LiveTailSessionStart) : this() {
            this.logEventFilterPattern = x.logEventFilterPattern
            this.logGroupIdentifiers = x.logGroupIdentifiers
            this.logStreamNamePrefixes = x.logStreamNamePrefixes
            this.logStreamNames = x.logStreamNames
            this.requestId = x.requestId
            this.sessionId = x.sessionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.LiveTailSessionStart = LiveTailSessionStart(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
