// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents an export task.
 */
public class ExportTask private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket to which the log data was exported.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The prefix that was used as the start of Amazon S3 key for every object exported.
     */
    public val destinationPrefix: kotlin.String? = builder.destinationPrefix
    /**
     * Execution information about the export task.
     */
    public val executionInfo: aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskExecutionInfo? = builder.executionInfo
    /**
     * The start time, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp before this time are not exported.
     */
    public val from: kotlin.Long? = builder.from
    /**
     * The name of the log group from which logs data was exported.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The status of the export task.
     */
    public val status: aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskStatus? = builder.status
    /**
     * The ID of the export task.
     */
    public val taskId: kotlin.String? = builder.taskId
    /**
     * The name of the export task.
     */
    public val taskName: kotlin.String? = builder.taskName
    /**
     * The end time, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp later than this time are not exported.
     */
    public val to: kotlin.Long? = builder.to

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportTask(")
        append("destination=$destination,")
        append("destinationPrefix=$destinationPrefix,")
        append("executionInfo=$executionInfo,")
        append("from=$from,")
        append("logGroupName=$logGroupName,")
        append("status=$status,")
        append("taskId=$taskId,")
        append("taskName=$taskName,")
        append("to=$to")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (destinationPrefix?.hashCode() ?: 0)
        result = 31 * result + (executionInfo?.hashCode() ?: 0)
        result = 31 * result + (from?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        result = 31 * result + (taskName?.hashCode() ?: 0)
        result = 31 * result + (to?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportTask

        if (destination != other.destination) return false
        if (destinationPrefix != other.destinationPrefix) return false
        if (executionInfo != other.executionInfo) return false
        if (from != other.from) return false
        if (logGroupName != other.logGroupName) return false
        if (status != other.status) return false
        if (taskId != other.taskId) return false
        if (taskName != other.taskName) return false
        if (to != other.to) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTask = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the S3 bucket to which the log data was exported.
         */
        public var destination: kotlin.String? = null
        /**
         * The prefix that was used as the start of Amazon S3 key for every object exported.
         */
        public var destinationPrefix: kotlin.String? = null
        /**
         * Execution information about the export task.
         */
        public var executionInfo: aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskExecutionInfo? = null
        /**
         * The start time, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp before this time are not exported.
         */
        public var from: kotlin.Long? = null
        /**
         * The name of the log group from which logs data was exported.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The status of the export task.
         */
        public var status: aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskStatus? = null
        /**
         * The ID of the export task.
         */
        public var taskId: kotlin.String? = null
        /**
         * The name of the export task.
         */
        public var taskName: kotlin.String? = null
        /**
         * The end time, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp later than this time are not exported.
         */
        public var to: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTask) : this() {
            this.destination = x.destination
            this.destinationPrefix = x.destinationPrefix
            this.executionInfo = x.executionInfo
            this.from = x.from
            this.logGroupName = x.logGroupName
            this.status = x.status
            this.taskId = x.taskId
            this.taskName = x.taskName
            this.to = x.to
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTask = ExportTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskExecutionInfo] inside the given [block]
         */
        public fun executionInfo(block: aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskExecutionInfo.Builder.() -> kotlin.Unit) {
            this.executionInfo = aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskExecutionInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.cloudwatchlogs.model.ExportTaskStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
