// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a cross-account destination that receives subscription log events.
 */
public class Destination private constructor(builder: Builder) {
    /**
     * An IAM policy document that governs which Amazon Web Services accounts can create subscription filters against this destination.
     */
    public val accessPolicy: kotlin.String? = builder.accessPolicy
    /**
     * The ARN of this destination.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The creation time of the destination, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
     */
    public val creationTime: kotlin.Long? = builder.creationTime
    /**
     * The name of the destination.
     */
    public val destinationName: kotlin.String? = builder.destinationName
    /**
     * A role for impersonation, used when delivering log events to the target.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the physical target where the log events are delivered (for example, a Kinesis stream).
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("accessPolicy=$accessPolicy,")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("destinationName=$destinationName,")
        append("roleArn=$roleArn,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicy?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (destinationName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (accessPolicy != other.accessPolicy) return false
        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (destinationName != other.destinationName) return false
        if (roleArn != other.roleArn) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An IAM policy document that governs which Amazon Web Services accounts can create subscription filters against this destination.
         */
        public var accessPolicy: kotlin.String? = null
        /**
         * The ARN of this destination.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time of the destination, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         */
        public var creationTime: kotlin.Long? = null
        /**
         * The name of the destination.
         */
        public var destinationName: kotlin.String? = null
        /**
         * A role for impersonation, used when delivering log events to the target.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the physical target where the log events are delivered (for example, a Kinesis stream).
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.Destination) : this() {
            this.accessPolicy = x.accessPolicy
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.destinationName = x.destinationName
            this.roleArn = x.roleArn
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.Destination = Destination(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
