// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains information about one *delivery* in your account.
 *
 * A delivery is a connection between a logical *delivery source* and a logical *delivery destination*.
 *
 * For more information, see [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html).
 *
 * You can't update an existing delivery. You can only create and delete deliveries.
 */
public class Delivery private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies this delivery.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The ARN of the delivery destination that is associated with this delivery.
     */
    public val deliveryDestinationArn: kotlin.String? = builder.deliveryDestinationArn
    /**
     * Displays whether the delivery destination associated with this delivery is CloudWatch Logs, Amazon S3, or Firehose.
     */
    public val deliveryDestinationType: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationType? = builder.deliveryDestinationType
    /**
     * The name of the delivery source that is associated with this delivery.
     */
    public val deliverySourceName: kotlin.String? = builder.deliverySourceName
    /**
     * The field delimiter that is used between record fields when the final output format of a delivery is in `Plain`, `W3C`, or `Raw` format.
     */
    public val fieldDelimiter: kotlin.String? = builder.fieldDelimiter
    /**
     * The unique ID that identifies this delivery in your account.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The record fields used in this delivery.
     */
    public val recordFields: List<String>? = builder.recordFields
    /**
     * This structure contains delivery configurations that apply only when the delivery destination resource is an S3 bucket.
     */
    public val s3DeliveryConfiguration: aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration? = builder.s3DeliveryConfiguration
    /**
     * The tags that have been assigned to this delivery.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.Delivery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Delivery(")
        append("arn=$arn,")
        append("deliveryDestinationArn=$deliveryDestinationArn,")
        append("deliveryDestinationType=$deliveryDestinationType,")
        append("deliverySourceName=$deliverySourceName,")
        append("fieldDelimiter=$fieldDelimiter,")
        append("id=$id,")
        append("recordFields=$recordFields,")
        append("s3DeliveryConfiguration=$s3DeliveryConfiguration,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (deliveryDestinationArn?.hashCode() ?: 0)
        result = 31 * result + (deliveryDestinationType?.hashCode() ?: 0)
        result = 31 * result + (deliverySourceName?.hashCode() ?: 0)
        result = 31 * result + (fieldDelimiter?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (recordFields?.hashCode() ?: 0)
        result = 31 * result + (s3DeliveryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Delivery

        if (arn != other.arn) return false
        if (deliveryDestinationArn != other.deliveryDestinationArn) return false
        if (deliveryDestinationType != other.deliveryDestinationType) return false
        if (deliverySourceName != other.deliverySourceName) return false
        if (fieldDelimiter != other.fieldDelimiter) return false
        if (id != other.id) return false
        if (recordFields != other.recordFields) return false
        if (s3DeliveryConfiguration != other.s3DeliveryConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.Delivery = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies this delivery.
         */
        public var arn: kotlin.String? = null
        /**
         * The ARN of the delivery destination that is associated with this delivery.
         */
        public var deliveryDestinationArn: kotlin.String? = null
        /**
         * Displays whether the delivery destination associated with this delivery is CloudWatch Logs, Amazon S3, or Firehose.
         */
        public var deliveryDestinationType: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationType? = null
        /**
         * The name of the delivery source that is associated with this delivery.
         */
        public var deliverySourceName: kotlin.String? = null
        /**
         * The field delimiter that is used between record fields when the final output format of a delivery is in `Plain`, `W3C`, or `Raw` format.
         */
        public var fieldDelimiter: kotlin.String? = null
        /**
         * The unique ID that identifies this delivery in your account.
         */
        public var id: kotlin.String? = null
        /**
         * The record fields used in this delivery.
         */
        public var recordFields: List<String>? = null
        /**
         * This structure contains delivery configurations that apply only when the delivery destination resource is an S3 bucket.
         */
        public var s3DeliveryConfiguration: aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration? = null
        /**
         * The tags that have been assigned to this delivery.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.Delivery) : this() {
            this.arn = x.arn
            this.deliveryDestinationArn = x.deliveryDestinationArn
            this.deliveryDestinationType = x.deliveryDestinationType
            this.deliverySourceName = x.deliverySourceName
            this.fieldDelimiter = x.fieldDelimiter
            this.id = x.id
            this.recordFields = x.recordFields
            this.s3DeliveryConfiguration = x.s3DeliveryConfiguration
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.Delivery = Delivery(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration] inside the given [block]
         */
        public fun s3DeliveryConfiguration(block: aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.s3DeliveryConfiguration = aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
