// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains the default values that are used for each configuration parameter when you use [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) to create a deliver under the current service type, resource type, and log type.
 */
public class ConfigurationTemplateDeliveryConfigValues private constructor(builder: Builder) {
    /**
     * The default field delimiter that is used in a [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) operation when the field delimiter is not specified in that operation. The field delimiter is used only when the final output delivery is in `Plain`, `W3C`, or `Raw` format.
     */
    public val fieldDelimiter: kotlin.String? = builder.fieldDelimiter
    /**
     * The default record fields that will be delivered when a list of record fields is not provided in a [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) operation.
     */
    public val recordFields: List<String>? = builder.recordFields
    /**
     * The delivery parameters that are used when you create a delivery to a delivery destination that is an S3 Bucket.
     */
    public val s3DeliveryConfiguration: aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration? = builder.s3DeliveryConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigurationTemplateDeliveryConfigValues(")
        append("fieldDelimiter=$fieldDelimiter,")
        append("recordFields=$recordFields,")
        append("s3DeliveryConfiguration=$s3DeliveryConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldDelimiter?.hashCode() ?: 0
        result = 31 * result + (recordFields?.hashCode() ?: 0)
        result = 31 * result + (s3DeliveryConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigurationTemplateDeliveryConfigValues

        if (fieldDelimiter != other.fieldDelimiter) return false
        if (recordFields != other.recordFields) return false
        if (s3DeliveryConfiguration != other.s3DeliveryConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The default field delimiter that is used in a [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) operation when the field delimiter is not specified in that operation. The field delimiter is used only when the final output delivery is in `Plain`, `W3C`, or `Raw` format.
         */
        public var fieldDelimiter: kotlin.String? = null
        /**
         * The default record fields that will be delivered when a list of record fields is not provided in a [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) operation.
         */
        public var recordFields: List<String>? = null
        /**
         * The delivery parameters that are used when you create a delivery to a delivery destination that is an S3 Bucket.
         */
        public var s3DeliveryConfiguration: aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues) : this() {
            this.fieldDelimiter = x.fieldDelimiter
            this.recordFields = x.recordFields
            this.s3DeliveryConfiguration = x.s3DeliveryConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues = ConfigurationTemplateDeliveryConfigValues(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration] inside the given [block]
         */
        public fun s3DeliveryConfiguration(block: aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.s3DeliveryConfiguration = aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
