// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure containing information about the deafult settings and available settings that you can use to configure a [delivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_Delivery.html) or a [delivery destination](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeliveryDestination.html).
 */
public class ConfigurationTemplate private constructor(builder: Builder) {
    /**
     * The action permissions that a caller needs to have to be able to successfully create a delivery source on the desired resource type when calling [PutDeliverySource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html).
     */
    public val allowedActionForAllowVendedLogsDeliveryForResource: kotlin.String? = builder.allowedActionForAllowVendedLogsDeliveryForResource
    /**
     * The valid values that a caller can use as field delimiters when calling [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) or [UpdateDeliveryConfiguration](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html) on a delivery that delivers in `Plain`, `W3C`, or `Raw` format.
     */
    public val allowedFieldDelimiters: List<String>? = builder.allowedFieldDelimiters
    /**
     * The allowed fields that a caller can use in the `recordFields` parameter of a [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) or [UpdateDeliveryConfiguration](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html) operation.
     */
    public val allowedFields: List<RecordField>? = builder.allowedFields
    /**
     * The list of delivery destination output formats that are supported by this log source.
     */
    public val allowedOutputFormats: List<OutputFormat>? = builder.allowedOutputFormats
    /**
     * The list of variable fields that can be used in the suffix path of a delivery that delivers to an S3 bucket.
     */
    public val allowedSuffixPathFields: List<String>? = builder.allowedSuffixPathFields
    /**
     * A mapping that displays the default value of each property within a delivery’s configuration, if it is not specified in the request.
     */
    public val defaultDeliveryConfigValues: aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues? = builder.defaultDeliveryConfigValues
    /**
     * A string specifying which destination type this configuration template applies to.
     */
    public val deliveryDestinationType: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationType? = builder.deliveryDestinationType
    /**
     * A string specifying which log type this configuration template applies to.
     */
    public val logType: kotlin.String? = builder.logType
    /**
     * A string specifying which resource type this configuration template applies to.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * A string specifying which service this configuration template applies to. For more information about supported services see [Enable logging from Amazon Web Services services.](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html).
     */
    public val service: kotlin.String? = builder.service

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigurationTemplate(")
        append("allowedActionForAllowVendedLogsDeliveryForResource=$allowedActionForAllowVendedLogsDeliveryForResource,")
        append("allowedFieldDelimiters=$allowedFieldDelimiters,")
        append("allowedFields=$allowedFields,")
        append("allowedOutputFormats=$allowedOutputFormats,")
        append("allowedSuffixPathFields=$allowedSuffixPathFields,")
        append("defaultDeliveryConfigValues=$defaultDeliveryConfigValues,")
        append("deliveryDestinationType=$deliveryDestinationType,")
        append("logType=$logType,")
        append("resourceType=$resourceType,")
        append("service=$service")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedActionForAllowVendedLogsDeliveryForResource?.hashCode() ?: 0
        result = 31 * result + (allowedFieldDelimiters?.hashCode() ?: 0)
        result = 31 * result + (allowedFields?.hashCode() ?: 0)
        result = 31 * result + (allowedOutputFormats?.hashCode() ?: 0)
        result = 31 * result + (allowedSuffixPathFields?.hashCode() ?: 0)
        result = 31 * result + (defaultDeliveryConfigValues?.hashCode() ?: 0)
        result = 31 * result + (deliveryDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logType?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigurationTemplate

        if (allowedActionForAllowVendedLogsDeliveryForResource != other.allowedActionForAllowVendedLogsDeliveryForResource) return false
        if (allowedFieldDelimiters != other.allowedFieldDelimiters) return false
        if (allowedFields != other.allowedFields) return false
        if (allowedOutputFormats != other.allowedOutputFormats) return false
        if (allowedSuffixPathFields != other.allowedSuffixPathFields) return false
        if (defaultDeliveryConfigValues != other.defaultDeliveryConfigValues) return false
        if (deliveryDestinationType != other.deliveryDestinationType) return false
        if (logType != other.logType) return false
        if (resourceType != other.resourceType) return false
        if (service != other.service) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action permissions that a caller needs to have to be able to successfully create a delivery source on the desired resource type when calling [PutDeliverySource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html).
         */
        public var allowedActionForAllowVendedLogsDeliveryForResource: kotlin.String? = null
        /**
         * The valid values that a caller can use as field delimiters when calling [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) or [UpdateDeliveryConfiguration](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html) on a delivery that delivers in `Plain`, `W3C`, or `Raw` format.
         */
        public var allowedFieldDelimiters: List<String>? = null
        /**
         * The allowed fields that a caller can use in the `recordFields` parameter of a [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html) or [UpdateDeliveryConfiguration](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html) operation.
         */
        public var allowedFields: List<RecordField>? = null
        /**
         * The list of delivery destination output formats that are supported by this log source.
         */
        public var allowedOutputFormats: List<OutputFormat>? = null
        /**
         * The list of variable fields that can be used in the suffix path of a delivery that delivers to an S3 bucket.
         */
        public var allowedSuffixPathFields: List<String>? = null
        /**
         * A mapping that displays the default value of each property within a delivery’s configuration, if it is not specified in the request.
         */
        public var defaultDeliveryConfigValues: aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues? = null
        /**
         * A string specifying which destination type this configuration template applies to.
         */
        public var deliveryDestinationType: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliveryDestinationType? = null
        /**
         * A string specifying which log type this configuration template applies to.
         */
        public var logType: kotlin.String? = null
        /**
         * A string specifying which resource type this configuration template applies to.
         */
        public var resourceType: kotlin.String? = null
        /**
         * A string specifying which service this configuration template applies to. For more information about supported services see [Enable logging from Amazon Web Services services.](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html).
         */
        public var service: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplate) : this() {
            this.allowedActionForAllowVendedLogsDeliveryForResource = x.allowedActionForAllowVendedLogsDeliveryForResource
            this.allowedFieldDelimiters = x.allowedFieldDelimiters
            this.allowedFields = x.allowedFields
            this.allowedOutputFormats = x.allowedOutputFormats
            this.allowedSuffixPathFields = x.allowedSuffixPathFields
            this.defaultDeliveryConfigValues = x.defaultDeliveryConfigValues
            this.deliveryDestinationType = x.deliveryDestinationType
            this.logType = x.logType
            this.resourceType = x.resourceType
            this.service = x.service
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplate = ConfigurationTemplate(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues] inside the given [block]
         */
        public fun defaultDeliveryConfigValues(block: aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues.Builder.() -> kotlin.Unit) {
            this.defaultDeliveryConfigValues = aws.sdk.kotlin.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
