// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartQueryRequest private constructor(builder: Builder) {
    /**
     * The end of the time range to query. The range is inclusive, so the specified end time is included in the query. Specified as epoch time, the number of seconds since `January 1, 1970, 00:00:00 UTC`.
     */
    public val endTime: kotlin.Long? = builder.endTime
    /**
     * The maximum number of log events to return in the query. If the query string uses the `fields` command, only the specified fields and their values are returned. The default is 1000.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The list of log groups to query. You can include up to 50 log groups.
     *
     * You can specify them by the log group name or ARN. If a log group that you're querying is in a source account and you're using a monitoring account, you must specify the ARN of the log group here. The query definition must also be defined in the monitoring account.
     *
     * If you specify an ARN, the ARN can't end with an asterisk (*).
     *
     * A `StartQuery` operation must include exactly one of the following parameters: `logGroupName`, `logGroupNames`, or `logGroupIdentifiers`.
     */
    public val logGroupIdentifiers: List<String>? = builder.logGroupIdentifiers
    /**
     * The log group on which to perform the query.
     *
     * A `StartQuery` operation must include exactly one of the following parameters: `logGroupName`, `logGroupNames`, or `logGroupIdentifiers`.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The list of log groups to be queried. You can include up to 50 log groups.
     *
     * A `StartQuery` operation must include exactly one of the following parameters: `logGroupName`, `logGroupNames`, or `logGroupIdentifiers`.
     */
    public val logGroupNames: List<String>? = builder.logGroupNames
    /**
     * The query string to use. For more information, see [CloudWatch Logs Insights Query Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
     */
    public val queryString: kotlin.String? = builder.queryString
    /**
     * The beginning of the time range to query. The range is inclusive, so the specified start time is included in the query. Specified as epoch time, the number of seconds since `January 1, 1970, 00:00:00 UTC`.
     */
    public val startTime: kotlin.Long? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.StartQueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartQueryRequest(")
        append("endTime=$endTime,")
        append("limit=$limit,")
        append("logGroupIdentifiers=$logGroupIdentifiers,")
        append("logGroupName=$logGroupName,")
        append("logGroupNames=$logGroupNames,")
        append("queryString=$queryString,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (logGroupIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (logGroupNames?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartQueryRequest

        if (endTime != other.endTime) return false
        if (limit != other.limit) return false
        if (logGroupIdentifiers != other.logGroupIdentifiers) return false
        if (logGroupName != other.logGroupName) return false
        if (logGroupNames != other.logGroupNames) return false
        if (queryString != other.queryString) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.StartQueryRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end of the time range to query. The range is inclusive, so the specified end time is included in the query. Specified as epoch time, the number of seconds since `January 1, 1970, 00:00:00 UTC`.
         */
        public var endTime: kotlin.Long? = null
        /**
         * The maximum number of log events to return in the query. If the query string uses the `fields` command, only the specified fields and their values are returned. The default is 1000.
         */
        public var limit: kotlin.Int? = null
        /**
         * The list of log groups to query. You can include up to 50 log groups.
         *
         * You can specify them by the log group name or ARN. If a log group that you're querying is in a source account and you're using a monitoring account, you must specify the ARN of the log group here. The query definition must also be defined in the monitoring account.
         *
         * If you specify an ARN, the ARN can't end with an asterisk (*).
         *
         * A `StartQuery` operation must include exactly one of the following parameters: `logGroupName`, `logGroupNames`, or `logGroupIdentifiers`.
         */
        public var logGroupIdentifiers: List<String>? = null
        /**
         * The log group on which to perform the query.
         *
         * A `StartQuery` operation must include exactly one of the following parameters: `logGroupName`, `logGroupNames`, or `logGroupIdentifiers`.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The list of log groups to be queried. You can include up to 50 log groups.
         *
         * A `StartQuery` operation must include exactly one of the following parameters: `logGroupName`, `logGroupNames`, or `logGroupIdentifiers`.
         */
        public var logGroupNames: List<String>? = null
        /**
         * The query string to use. For more information, see [CloudWatch Logs Insights Query Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
         */
        public var queryString: kotlin.String? = null
        /**
         * The beginning of the time range to query. The range is inclusive, so the specified start time is included in the query. Specified as epoch time, the number of seconds since `January 1, 1970, 00:00:00 UTC`.
         */
        public var startTime: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.StartQueryRequest) : this() {
            this.endTime = x.endTime
            this.limit = x.limit
            this.logGroupIdentifiers = x.logGroupIdentifiers
            this.logGroupName = x.logGroupName
            this.logGroupNames = x.logGroupNames
            this.queryString = x.queryString
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.StartQueryRequest = StartQueryRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
