// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains one field from one log event returned by a CloudWatch Logs Insights query, along with the value of that field.
 *
 * For more information about the fields that are generated by CloudWatch logs, see [Supported Logs and Discovered Fields](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html).
 */
public class ResultField private constructor(builder: Builder) {
    /**
     * The log event field.
     */
    public val field: kotlin.String? = builder.field
    /**
     * The value of this field.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.ResultField = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResultField(")
        append("field=$field,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = field?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResultField

        if (field != other.field) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.ResultField = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The log event field.
         */
        public var field: kotlin.String? = null
        /**
         * The value of this field.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.ResultField) : this() {
            this.field = x.field
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.ResultField = ResultField(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
