// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutDestinationRequest private constructor(builder: Builder) {
    /**
     * A name for the destination.
     */
    public val destinationName: kotlin.String? = builder.destinationName
    /**
     * The ARN of an IAM role that grants CloudWatch Logs permissions to call the Amazon Kinesis `PutRecord` operation on the destination stream.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * An optional list of key-value pairs to associate with the resource.
     *
     * For more information about tagging, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ARN of an Amazon Kinesis stream to which to deliver matching log events.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDestinationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutDestinationRequest(")
        append("destinationName=$destinationName,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationName?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutDestinationRequest

        if (destinationName != other.destinationName) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDestinationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A name for the destination.
         */
        public var destinationName: kotlin.String? = null
        /**
         * The ARN of an IAM role that grants CloudWatch Logs permissions to call the Amazon Kinesis `PutRecord` operation on the destination stream.
         */
        public var roleArn: kotlin.String? = null
        /**
         * An optional list of key-value pairs to associate with the resource.
         *
         * For more information about tagging, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
         */
        public var tags: Map<String, String>? = null
        /**
         * The ARN of an Amazon Kinesis stream to which to deliver matching log events.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.PutDestinationRequest) : this() {
            this.destinationName = x.destinationName
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.PutDestinationRequest = PutDestinationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
