// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Metric filters express how CloudWatch Logs would extract metric observations from ingested log events and transform them into metric data in a CloudWatch metric.
 */
public class MetricFilter private constructor(builder: Builder) {
    /**
     * The creation time of the metric filter, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
     */
    public val creationTime: kotlin.Long? = builder.creationTime
    /**
     * The name of the metric filter.
     */
    public val filterName: kotlin.String? = builder.filterName
    /**
     * A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.
     */
    public val filterPattern: kotlin.String? = builder.filterPattern
    /**
     * The name of the log group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The metric transformations.
     */
    public val metricTransformations: List<MetricTransformation>? = builder.metricTransformations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.MetricFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricFilter(")
        append("creationTime=$creationTime,")
        append("filterName=$filterName,")
        append("filterPattern=$filterPattern,")
        append("logGroupName=$logGroupName,")
        append("metricTransformations=$metricTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (filterName?.hashCode() ?: 0)
        result = 31 * result + (filterPattern?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (metricTransformations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricFilter

        if (creationTime != other.creationTime) return false
        if (filterName != other.filterName) return false
        if (filterPattern != other.filterPattern) return false
        if (logGroupName != other.logGroupName) return false
        if (metricTransformations != other.metricTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.MetricFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The creation time of the metric filter, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
         */
        public var creationTime: kotlin.Long? = null
        /**
         * The name of the metric filter.
         */
        public var filterName: kotlin.String? = null
        /**
         * A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.
         */
        public var filterPattern: kotlin.String? = null
        /**
         * The name of the log group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The metric transformations.
         */
        public var metricTransformations: List<MetricTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.MetricFilter) : this() {
            this.creationTime = x.creationTime
            this.filterName = x.filterName
            this.filterPattern = x.filterPattern
            this.logGroupName = x.logGroupName
            this.metricTransformations = x.metricTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.MetricFilter = MetricFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
