// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a log event, which is a record of activity that was recorded by the application or resource being monitored.
 */
public class InputLogEvent private constructor(builder: Builder) {
    /**
     * The raw event message. Each log event can be no larger than 256 KB.
     */
    public val message: kotlin.String = requireNotNull(builder.message) { "A non-null value must be provided for message" }
    /**
     * The time the event occurred, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
     */
    public val timestamp: kotlin.Long = requireNotNull(builder.timestamp) { "A non-null value must be provided for timestamp" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.InputLogEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputLogEvent(")
        append("message=$message,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (timestamp.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputLogEvent

        if (message != other.message) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.InputLogEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The raw event message. Each log event can be no larger than 256 KB.
         */
        public var message: kotlin.String? = null
        /**
         * The time the event occurred, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
         */
        public var timestamp: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.InputLogEvent) : this() {
            this.message = x.message
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.InputLogEvent = InputLogEvent(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            if (timestamp == null) timestamp = 0L
            return this
        }
    }
}
